/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.endpoints;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultException;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultExceptionConstraint;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import java.util.List;
import java.util.function.Consumer;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.lang.Nullable;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssaultPropertiesUpdate {
    @Nullable
    @Min(value=1L)
    @Max(value=10000L)
    private @Min(value=1L) @Max(value=10000L) Integer level;
    @Nullable
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) Integer latencyRangeStart;
    @Nullable
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) Integer latencyRangeEnd;
    @Nullable
    private Boolean latencyActive;
    @Nullable
    private Boolean exceptionsActive;
    @AssaultExceptionConstraint
    private AssaultException exception;
    @Nullable
    private Boolean killApplicationActive;
    @Nullable
    private volatile Boolean memoryActive;
    @Nullable
    @Min(value=1500L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1500L) @Max(value=0x7FFFFFFFL) Integer memoryMillisecondsHoldFilledMemory;
    @Nullable
    @Min(value=100L)
    @Max(value=30000L)
    private @Min(value=100L) @Max(value=30000L) Integer memoryMillisecondsWaitNextIncrease;
    @Nullable
    @DecimalMax(value="1.0")
    @DecimalMin(value="0.0")
    private @DecimalMax(value="1.0") @DecimalMin(value="0.0") Double memoryFillIncrementFraction;
    @Nullable
    @DecimalMax(value="0.95")
    @DecimalMin(value="0.05")
    private @DecimalMax(value="0.95") @DecimalMin(value="0.05") Double memoryFillTargetFraction;
    @Nullable
    private String runtimeAssaultCronExpression;
    @Nullable
    private List<String> watchedCustomServices;

    private <T> void applyTo(T value, Consumer<T> setter) {
        if (value != null) {
            setter.accept(value);
        }
    }

    public void applyTo(AssaultProperties t) {
        this.applyTo(this.level, t::setLevel);
        this.applyTo(this.latencyActive, t::setLatencyActive);
        this.applyTo(this.latencyRangeStart, t::setLatencyRangeStart);
        this.applyTo(this.latencyRangeEnd, t::setLatencyRangeEnd);
        this.applyTo(this.exceptionsActive, t::setExceptionsActive);
        this.applyTo(this.exception, t::setException);
        this.applyTo(this.killApplicationActive, t::setKillApplicationActive);
        this.applyTo(this.memoryActive, t::setMemoryActive);
        this.applyTo(this.memoryMillisecondsHoldFilledMemory, t::setMemoryMillisecondsHoldFilledMemory);
        this.applyTo(this.memoryMillisecondsWaitNextIncrease, t::setMemoryMillisecondsWaitNextIncrease);
        this.applyTo(this.memoryFillIncrementFraction, t::setMemoryFillIncrementFraction);
        this.applyTo(this.memoryFillTargetFraction, t::setMemoryFillTargetFraction);
        this.applyTo(this.runtimeAssaultCronExpression, t::setRuntimeAssaultCronExpression);
        this.applyTo(this.watchedCustomServices, t::setWatchedCustomServices);
    }

    @Nullable
    public Integer getLevel() {
        return this.level;
    }

    @Nullable
    public Integer getLatencyRangeStart() {
        return this.latencyRangeStart;
    }

    @Nullable
    public Integer getLatencyRangeEnd() {
        return this.latencyRangeEnd;
    }

    @Nullable
    public Boolean getLatencyActive() {
        return this.latencyActive;
    }

    @Nullable
    public Boolean getExceptionsActive() {
        return this.exceptionsActive;
    }

    public AssaultException getException() {
        return this.exception;
    }

    @Nullable
    public Boolean getKillApplicationActive() {
        return this.killApplicationActive;
    }

    @Nullable
    public Boolean getMemoryActive() {
        return this.memoryActive;
    }

    @Nullable
    public Integer getMemoryMillisecondsHoldFilledMemory() {
        return this.memoryMillisecondsHoldFilledMemory;
    }

    @Nullable
    public Integer getMemoryMillisecondsWaitNextIncrease() {
        return this.memoryMillisecondsWaitNextIncrease;
    }

    @Nullable
    public Double getMemoryFillIncrementFraction() {
        return this.memoryFillIncrementFraction;
    }

    @Nullable
    public Double getMemoryFillTargetFraction() {
        return this.memoryFillTargetFraction;
    }

    @Nullable
    public String getRuntimeAssaultCronExpression() {
        return this.runtimeAssaultCronExpression;
    }

    @Nullable
    public List<String> getWatchedCustomServices() {
        return this.watchedCustomServices;
    }

    public void setLevel(@Nullable Integer level) {
        this.level = level;
    }

    public void setLatencyRangeStart(@Nullable Integer latencyRangeStart) {
        this.latencyRangeStart = latencyRangeStart;
    }

    public void setLatencyRangeEnd(@Nullable Integer latencyRangeEnd) {
        this.latencyRangeEnd = latencyRangeEnd;
    }

    public void setLatencyActive(@Nullable Boolean latencyActive) {
        this.latencyActive = latencyActive;
    }

    public void setExceptionsActive(@Nullable Boolean exceptionsActive) {
        this.exceptionsActive = exceptionsActive;
    }

    public void setException(AssaultException exception) {
        this.exception = exception;
    }

    public void setKillApplicationActive(@Nullable Boolean killApplicationActive) {
        this.killApplicationActive = killApplicationActive;
    }

    public void setMemoryActive(@Nullable Boolean memoryActive) {
        this.memoryActive = memoryActive;
    }

    public void setMemoryMillisecondsHoldFilledMemory(@Nullable Integer memoryMillisecondsHoldFilledMemory) {
        this.memoryMillisecondsHoldFilledMemory = memoryMillisecondsHoldFilledMemory;
    }

    public void setMemoryMillisecondsWaitNextIncrease(@Nullable Integer memoryMillisecondsWaitNextIncrease) {
        this.memoryMillisecondsWaitNextIncrease = memoryMillisecondsWaitNextIncrease;
    }

    public void setMemoryFillIncrementFraction(@Nullable Double memoryFillIncrementFraction) {
        this.memoryFillIncrementFraction = memoryFillIncrementFraction;
    }

    public void setMemoryFillTargetFraction(@Nullable Double memoryFillTargetFraction) {
        this.memoryFillTargetFraction = memoryFillTargetFraction;
    }

    public void setRuntimeAssaultCronExpression(@Nullable String runtimeAssaultCronExpression) {
        this.runtimeAssaultCronExpression = runtimeAssaultCronExpression;
    }

    public void setWatchedCustomServices(@Nullable List<String> watchedCustomServices) {
        this.watchedCustomServices = watchedCustomServices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultPropertiesUpdate)) {
            return false;
        }
        AssaultPropertiesUpdate other = (AssaultPropertiesUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        Integer this$latencyRangeStart = this.getLatencyRangeStart();
        Integer other$latencyRangeStart = other.getLatencyRangeStart();
        if (this$latencyRangeStart == null ? other$latencyRangeStart != null : !((Object)this$latencyRangeStart).equals(other$latencyRangeStart)) {
            return false;
        }
        Integer this$latencyRangeEnd = this.getLatencyRangeEnd();
        Integer other$latencyRangeEnd = other.getLatencyRangeEnd();
        if (this$latencyRangeEnd == null ? other$latencyRangeEnd != null : !((Object)this$latencyRangeEnd).equals(other$latencyRangeEnd)) {
            return false;
        }
        Boolean this$latencyActive = this.getLatencyActive();
        Boolean other$latencyActive = other.getLatencyActive();
        if (this$latencyActive == null ? other$latencyActive != null : !((Object)this$latencyActive).equals(other$latencyActive)) {
            return false;
        }
        Boolean this$exceptionsActive = this.getExceptionsActive();
        Boolean other$exceptionsActive = other.getExceptionsActive();
        if (this$exceptionsActive == null ? other$exceptionsActive != null : !((Object)this$exceptionsActive).equals(other$exceptionsActive)) {
            return false;
        }
        Boolean this$killApplicationActive = this.getKillApplicationActive();
        Boolean other$killApplicationActive = other.getKillApplicationActive();
        if (this$killApplicationActive == null ? other$killApplicationActive != null : !((Object)this$killApplicationActive).equals(other$killApplicationActive)) {
            return false;
        }
        Boolean this$memoryActive = this.getMemoryActive();
        Boolean other$memoryActive = other.getMemoryActive();
        if (this$memoryActive == null ? other$memoryActive != null : !((Object)this$memoryActive).equals(other$memoryActive)) {
            return false;
        }
        Integer this$memoryMillisecondsHoldFilledMemory = this.getMemoryMillisecondsHoldFilledMemory();
        Integer other$memoryMillisecondsHoldFilledMemory = other.getMemoryMillisecondsHoldFilledMemory();
        if (this$memoryMillisecondsHoldFilledMemory == null ? other$memoryMillisecondsHoldFilledMemory != null : !((Object)this$memoryMillisecondsHoldFilledMemory).equals(other$memoryMillisecondsHoldFilledMemory)) {
            return false;
        }
        Integer this$memoryMillisecondsWaitNextIncrease = this.getMemoryMillisecondsWaitNextIncrease();
        Integer other$memoryMillisecondsWaitNextIncrease = other.getMemoryMillisecondsWaitNextIncrease();
        if (this$memoryMillisecondsWaitNextIncrease == null ? other$memoryMillisecondsWaitNextIncrease != null : !((Object)this$memoryMillisecondsWaitNextIncrease).equals(other$memoryMillisecondsWaitNextIncrease)) {
            return false;
        }
        Double this$memoryFillIncrementFraction = this.getMemoryFillIncrementFraction();
        Double other$memoryFillIncrementFraction = other.getMemoryFillIncrementFraction();
        if (this$memoryFillIncrementFraction == null ? other$memoryFillIncrementFraction != null : !((Object)this$memoryFillIncrementFraction).equals(other$memoryFillIncrementFraction)) {
            return false;
        }
        Double this$memoryFillTargetFraction = this.getMemoryFillTargetFraction();
        Double other$memoryFillTargetFraction = other.getMemoryFillTargetFraction();
        if (this$memoryFillTargetFraction == null ? other$memoryFillTargetFraction != null : !((Object)this$memoryFillTargetFraction).equals(other$memoryFillTargetFraction)) {
            return false;
        }
        AssaultException this$exception = this.getException();
        AssaultException other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception)) {
            return false;
        }
        String this$runtimeAssaultCronExpression = this.getRuntimeAssaultCronExpression();
        String other$runtimeAssaultCronExpression = other.getRuntimeAssaultCronExpression();
        if (this$runtimeAssaultCronExpression == null ? other$runtimeAssaultCronExpression != null : !this$runtimeAssaultCronExpression.equals(other$runtimeAssaultCronExpression)) {
            return false;
        }
        List<String> this$watchedCustomServices = this.getWatchedCustomServices();
        List<String> other$watchedCustomServices = other.getWatchedCustomServices();
        return !(this$watchedCustomServices == null ? other$watchedCustomServices != null : !((Object)this$watchedCustomServices).equals(other$watchedCustomServices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssaultPropertiesUpdate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        Integer $latencyRangeStart = this.getLatencyRangeStart();
        result = result * 59 + ($latencyRangeStart == null ? 43 : ((Object)$latencyRangeStart).hashCode());
        Integer $latencyRangeEnd = this.getLatencyRangeEnd();
        result = result * 59 + ($latencyRangeEnd == null ? 43 : ((Object)$latencyRangeEnd).hashCode());
        Boolean $latencyActive = this.getLatencyActive();
        result = result * 59 + ($latencyActive == null ? 43 : ((Object)$latencyActive).hashCode());
        Boolean $exceptionsActive = this.getExceptionsActive();
        result = result * 59 + ($exceptionsActive == null ? 43 : ((Object)$exceptionsActive).hashCode());
        Boolean $killApplicationActive = this.getKillApplicationActive();
        result = result * 59 + ($killApplicationActive == null ? 43 : ((Object)$killApplicationActive).hashCode());
        Boolean $memoryActive = this.getMemoryActive();
        result = result * 59 + ($memoryActive == null ? 43 : ((Object)$memoryActive).hashCode());
        Integer $memoryMillisecondsHoldFilledMemory = this.getMemoryMillisecondsHoldFilledMemory();
        result = result * 59 + ($memoryMillisecondsHoldFilledMemory == null ? 43 : ((Object)$memoryMillisecondsHoldFilledMemory).hashCode());
        Integer $memoryMillisecondsWaitNextIncrease = this.getMemoryMillisecondsWaitNextIncrease();
        result = result * 59 + ($memoryMillisecondsWaitNextIncrease == null ? 43 : ((Object)$memoryMillisecondsWaitNextIncrease).hashCode());
        Double $memoryFillIncrementFraction = this.getMemoryFillIncrementFraction();
        result = result * 59 + ($memoryFillIncrementFraction == null ? 43 : ((Object)$memoryFillIncrementFraction).hashCode());
        Double $memoryFillTargetFraction = this.getMemoryFillTargetFraction();
        result = result * 59 + ($memoryFillTargetFraction == null ? 43 : ((Object)$memoryFillTargetFraction).hashCode());
        AssaultException $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
        String $runtimeAssaultCronExpression = this.getRuntimeAssaultCronExpression();
        result = result * 59 + ($runtimeAssaultCronExpression == null ? 43 : $runtimeAssaultCronExpression.hashCode());
        List<String> $watchedCustomServices = this.getWatchedCustomServices();
        result = result * 59 + ($watchedCustomServices == null ? 43 : ((Object)$watchedCustomServices).hashCode());
        return result;
    }

    public String toString() {
        return "AssaultPropertiesUpdate(level=" + this.getLevel() + ", latencyRangeStart=" + this.getLatencyRangeStart() + ", latencyRangeEnd=" + this.getLatencyRangeEnd() + ", latencyActive=" + this.getLatencyActive() + ", exceptionsActive=" + this.getExceptionsActive() + ", exception=" + this.getException() + ", killApplicationActive=" + this.getKillApplicationActive() + ", memoryActive=" + this.getMemoryActive() + ", memoryMillisecondsHoldFilledMemory=" + this.getMemoryMillisecondsHoldFilledMemory() + ", memoryMillisecondsWaitNextIncrease=" + this.getMemoryMillisecondsWaitNextIncrease() + ", memoryFillIncrementFraction=" + this.getMemoryFillIncrementFraction() + ", memoryFillTargetFraction=" + this.getMemoryFillTargetFraction() + ", runtimeAssaultCronExpression=" + this.getRuntimeAssaultCronExpression() + ", watchedCustomServices=" + this.getWatchedCustomServices() + ")";
    }
}

