/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.watcher.ChaosMonkeyBaseAspect;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class SpringServiceAspect
extends ChaosMonkeyBaseAspect {
    private static final Logger log = LoggerFactory.getLogger(SpringServiceAspect.class);
    private final ChaosMonkeyRequestScope chaosMonkeyRequestScope;
    private MetricEventPublisher metricEventPublisher;
    private WatcherProperties watcherProperties;

    @Pointcut(value="within(@org.springframework.stereotype.Service *)")
    public void classAnnotatedWithControllerPointcut() {
    }

    @Around(value="classAnnotatedWithControllerPointcut() && allPublicMethodPointcut() && !classInChaosMonkeyPackage()")
    public Object intercept(ProceedingJoinPoint pjp) throws Throwable {
        if (this.watcherProperties.isService()) {
            log.debug("Watching public method on service class: {}", (Object)pjp.getSignature());
            if (this.metricEventPublisher != null) {
                this.metricEventPublisher.publishMetricEvent(this.calculatePointcut(pjp.toShortString()), MetricType.SERVICE, new String[0]);
            }
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            this.chaosMonkeyRequestScope.callChaosMonkey(this.createSignature(signature));
        }
        return pjp.proceed();
    }

    public SpringServiceAspect(ChaosMonkeyRequestScope chaosMonkeyRequestScope, MetricEventPublisher metricEventPublisher, WatcherProperties watcherProperties) {
        this.chaosMonkeyRequestScope = chaosMonkeyRequestScope;
        this.metricEventPublisher = metricEventPublisher;
        this.watcherProperties = watcherProperties;
    }
}

