/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.assaults;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRequestAssault;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultException;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionAssault
implements ChaosMonkeyRequestAssault {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionAssault.class);
    private final ChaosMonkeySettings settings;
    private MetricEventPublisher metricEventPublisher;

    public ExceptionAssault(ChaosMonkeySettings settings, MetricEventPublisher metricEventPublisher) {
        this.settings = settings;
        this.metricEventPublisher = metricEventPublisher;
    }

    @Override
    public boolean isActive() {
        return this.settings.getAssaultProperties().isExceptionsActive();
    }

    @Override
    public void attack() {
        LOGGER.info("Chaos Monkey - exception");
        AssaultException assaultException = this.settings.getAssaultProperties().getException();
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.publishMetricEvent(MetricType.EXCEPTION_ASSAULT, new String[0]);
        }
        assaultException.throwExceptionInstance();
    }
}

