/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkey;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.watcher.ChaosMonkeyBaseAspect;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class SpringServiceAspect
extends ChaosMonkeyBaseAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringServiceAspect.class);
    private final ChaosMonkey chaosMonkey;
    private MetricEventPublisher metricEventPublisher;

    public SpringServiceAspect(ChaosMonkey chaosMonkey, MetricEventPublisher metricEventPublisher) {
        this.chaosMonkey = chaosMonkey;
        this.metricEventPublisher = metricEventPublisher;
    }

    @Pointcut(value="within(@org.springframework.stereotype.Service *)")
    public void classAnnotatedWithControllerPointcut() {
    }

    @Around(value="classAnnotatedWithControllerPointcut() && allPublicMethodPointcut() && !classInChaosMonkeyPackage()")
    public Object intercept(ProceedingJoinPoint pjp) throws Throwable {
        LOGGER.debug(LOGGER.isDebugEnabled() ? "Service class and public method detected: " + pjp.getSignature() : null);
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.publishMetricEvent(this.calculatePointcut(pjp.toShortString()), MetricType.SERVICE, new String[0]);
        }
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        this.chaosMonkey.callChaosMonkey(this.createSignature(signature));
        return pjp.proceed();
    }
}

