/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.component;

import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.events.MetricEvent;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.ApplicationListener;

public class Metrics
implements ApplicationListener<MetricEvent> {
    private MeterRegistry meterRegistry = io.micrometer.core.instrument.Metrics.globalRegistry;

    private void counter(MetricType type, String ... tags) {
        if (this.meterRegistry != null) {
            this.meterRegistry.counter(type.getMetricName(), tags).increment();
        }
    }

    private void counterWatcher(MetricType type, String name) {
        if (this.meterRegistry != null) {
            this.meterRegistry.counter(type.getMetricName() + ".watcher", new String[]{"component", this.extractComponent(name)}).increment();
        }
    }

    private void gauge(MetricType type, AtomicInteger number) {
        if (this.meterRegistry != null) {
            this.meterRegistry.gauge(type.getMetricName() + ".gauge.", (Number)number);
        }
    }

    private String extractComponent(String name) {
        return name.replaceAll("execution.", "");
    }

    public void onApplicationEvent(MetricEvent event) {
        switch (event.getMetricType()) {
            case SERVICE: {
                this.counterWatcher(event.getMetricType(), event.getMethodSignature());
                break;
            }
            case COMPONENT: {
                this.counterWatcher(event.getMetricType(), event.getMethodSignature());
                break;
            }
            case REPOSITORY: {
                this.counterWatcher(event.getMetricType(), event.getMethodSignature());
                break;
            }
            case RESTCONTROLLER: {
                this.counterWatcher(event.getMetricType(), event.getMethodSignature());
                break;
            }
            case CONTROLLER: {
                this.counterWatcher(event.getMetricType(), event.getMethodSignature());
                break;
            }
            case LATENCY_ASSAULT: {
                if (event.getGaugeValue() != null) {
                    this.gauge(event.getMetricType(), event.getGaugeValue());
                }
                this.counter(event.getMetricType(), event.getTags());
                break;
            }
            case APPLICATION_REQ_COUNT: {
                this.counter(event.getMetricType(), event.getTags());
                break;
            }
            case KILLAPP_ASSAULT: {
                this.counter(event.getMetricType(), event.getTags());
                break;
            }
            case EXCEPTION_ASSAULT: {
                this.counter(event.getMetricType(), event.getTags());
                break;
            }
        }
    }
}

