/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.endpoints;

import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.mvc.AbstractMvcEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Component
public class ChaosMonkeyRestEndpoint
extends AbstractMvcEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChaosMonkeyRestEndpoint.class);
    private ChaosMonkeySettings chaosMonkeySettings;

    public ChaosMonkeyRestEndpoint(ChaosMonkeySettings chaosMonkeySettings) {
        super("/chaosmonkey", false, true);
        LOGGER.info("ChaosMonkeyRestEndpoint enabled");
        this.chaosMonkeySettings = chaosMonkeySettings;
    }

    @RequestMapping(value={"/assaults"}, method={RequestMethod.POST}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    @ResponseBody
    public ResponseEntity updateAssaultProperties(@RequestBody @Validated AssaultProperties assaultProperties) {
        this.chaosMonkeySettings.setAssaultProperties(assaultProperties);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/assaults"}, method={RequestMethod.GET}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    @ResponseBody
    public AssaultProperties getAssaultSettings() {
        return this.chaosMonkeySettings.getAssaultProperties();
    }

    @RequestMapping(value={"/enable"}, method={RequestMethod.POST}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    @ResponseBody
    public ResponseEntity enableChaosMonkey() {
        this.chaosMonkeySettings.getChaosMonkeyProperties().setEnabled(true);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/disable"}, method={RequestMethod.POST}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    @ResponseBody
    public ResponseEntity disableChaosMonkey() {
        this.chaosMonkeySettings.getChaosMonkeyProperties().setEnabled(false);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    @ResponseBody
    public ChaosMonkeySettings config() {
        return this.chaosMonkeySettings;
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.GET}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    @ResponseBody
    public ResponseEntity getStatus() {
        if (this.chaosMonkeySettings.getChaosMonkeyProperties().isEnabled()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).build();
    }

    @RequestMapping(value={"/watcher"}, method={RequestMethod.GET}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    @ResponseBody
    public WatcherProperties getWatcherSettings() {
        return this.chaosMonkeySettings.getWatcherProperties();
    }
}

