/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.component;

import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ChaosMonkey {
    private final AssaultProperties assaultProperties;
    @Autowired
    private ApplicationContext context;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChaosMonkey.class);

    public ChaosMonkey(AssaultProperties assaultProperties) {
        this.assaultProperties = assaultProperties;
    }

    public void callChaosMonkey() {
        int troubleRand = this.assaultProperties.getTroubleRandom();
        int exceptionRand = this.assaultProperties.getExceptionRandom();
        if (troubleRand > this.assaultProperties.getLevel()) {
            if (this.assaultProperties.isLatencyActive() && this.assaultProperties.isExceptionsActive()) {
                if (exceptionRand < 7) {
                    this.generateLatency();
                } else {
                    this.generateChaosException();
                }
            } else if (this.assaultProperties.isLatencyActive()) {
                this.generateLatency();
            } else if (this.assaultProperties.isExceptionsActive()) {
                this.generateChaosException();
            } else if (this.assaultProperties.isKillApplicationActive()) {
                this.killTheBossApp();
            }
        }
    }

    private void killTheBossApp() {
        try {
            LOGGER.info("Chaos Monkey - I am killing your Application!");
            int exit = SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{new ExitCodeGenerator(){

                public int getExitCode() {
                    return 0;
                }
            }});
            System.exit(exit);
        }
        catch (Exception e) {
            LOGGER.info("Chaos Monkey - Unable to kill the App, I am not the BOSS!");
        }
    }

    private void generateChaosException() {
        LOGGER.info("Chaos Monkey - exception");
        throw new RuntimeException("Chaos Monkey - RuntimeException");
    }

    private void generateLatency() {
        LOGGER.info("Chaos Monkey - timeout");
        int timeout = RandomUtils.nextInt((int)this.assaultProperties.getLatencyRangeStart(), (int)this.assaultProperties.getLatencyRangeEnd());
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

