/*
 * Decompiled with CFR 0.152.
 */
package de.cketti.safecontentresolver;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import de.cketti.safecontentresolver.DisallowedProviders;
import de.cketti.safecontentresolver.SafeContentResolverApi21;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SafeContentResolver {
    private final ContentResolver contentResolver;
    private final DisallowedProviders disallowedProviders;

    @NotNull
    public static SafeContentResolver newInstance(@NotNull Context context) {
        if (context == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        return new SafeContentResolverApi21(context);
    }

    protected SafeContentResolver(@NotNull Context context) {
        this.contentResolver = context.getContentResolver();
        this.disallowedProviders = new DisallowedProviders(context);
    }

    @Nullable
    public InputStream openInputStream(@NotNull Uri uri) throws FileNotFoundException {
        String authority;
        if (uri == null) {
            throw new NullPointerException("Argument 'uri' must not be null");
        }
        String scheme = uri.getScheme();
        if ("content".equals(scheme) && this.disallowedProviders.isDisallowed(authority = uri.getAuthority())) {
            throw new FileNotFoundException("content URI is owned by the application itself. Content provider is not explicitly allowed: " + authority);
        }
        if (!"file".equals(scheme)) {
            return this.contentResolver.openInputStream(uri);
        }
        File file = new File(uri.getPath());
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
        int fileUid = this.getFileUidOrThrow(fileDescriptor);
        if (fileUid == Process.myUid()) {
            throw new FileNotFoundException("File is owned by the application itself");
        }
        AssetFileDescriptor fd = new AssetFileDescriptor(parcelFileDescriptor, 0L, -1L);
        try {
            return fd.createInputStream();
        }
        catch (IOException e) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    protected abstract int getFileUidOrThrow(@NotNull FileDescriptor var1) throws FileNotFoundException;
}

