/*
 * I18N resource strings
 *
 * Generated on 21.09.2017 21:26:45
 */
package de.carne.jfx.stage.logview;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * Package localization resources.
 */
public final class LogViewI18N {

	/**
	 * The BUNDLE represented by this class.
	 */
	public static final ResourceBundle BUNDLE = ResourceBundle.getBundle(LogViewI18N.class.getName());

	/**
	 * Format a resource string.
	 * @param key The resource key.
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String format(String key, Object... arguments) {
		String pattern = BUNDLE.getString(key);

		return (arguments.length > 0 ? MessageFormat.format(pattern, arguments) : pattern);
	}

	/**
	 * Resource key {@code STR_FILTER_ALLFILES}
	 * <p>
	 * All files|*.*
	 */
	public static final String STR_FILTER_ALLFILES = "STR_FILTER_ALLFILES";

	/**
	 * Resource string {@code STR_FILTER_ALLFILES}
	 * <p>
	 * All files|*.*
	 *
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String formatSTR_FILTER_ALLFILES(Object... arguments) {
		return format(STR_FILTER_ALLFILES, arguments);
	}

	/**
	 * Resource key {@code STR_FILTER_LOGFILES}
	 * <p>
	 * Log files|*.log
	 */
	public static final String STR_FILTER_LOGFILES = "STR_FILTER_LOGFILES";

	/**
	 * Resource string {@code STR_FILTER_LOGFILES}
	 * <p>
	 * Log files|*.log
	 *
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String formatSTR_FILTER_LOGFILES(Object... arguments) {
		return format(STR_FILTER_LOGFILES, arguments);
	}

	/**
	 * Resource key {@code STR_FILTER_TXTFILES}
	 * <p>
	 * Text files|*.txt
	 */
	public static final String STR_FILTER_TXTFILES = "STR_FILTER_TXTFILES";

	/**
	 * Resource string {@code STR_FILTER_TXTFILES}
	 * <p>
	 * Text files|*.txt
	 *
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String formatSTR_FILTER_TXTFILES(Object... arguments) {
		return format(STR_FILTER_TXTFILES, arguments);
	}

	/**
	 * Resource key {@code STR_STAGE_TITLE}
	 * <p>
	 * Log messages
	 */
	public static final String STR_STAGE_TITLE = "STR_STAGE_TITLE";

	/**
	 * Resource string {@code STR_STAGE_TITLE}
	 * <p>
	 * Log messages
	 *
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String formatSTR_STAGE_TITLE(Object... arguments) {
		return format(STR_STAGE_TITLE, arguments);
	}

}
