/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.check.Nullable;
import de.carne.util.Exceptions;
import de.carne.util.prefs.Preference;
import java.util.prefs.Preferences;

public class LongPreference
extends Preference<Long> {
    public LongPreference(Preferences preferences, String key) {
        super(preferences, key);
    }

    public long getLong(long defaultValue) {
        return this.preferences().getLong(this.key(), defaultValue);
    }

    public void putLong(long value) {
        this.preferences().putLong(this.key(), value);
    }

    @Override
    @Nullable
    protected Long toValue(String valueString) {
        Long value = null;
        try {
            value = Long.valueOf(valueString);
        }
        catch (NumberFormatException e) {
            Exceptions.ignore(e);
        }
        return value;
    }

    @Override
    protected String fromValue(Long value) {
        return value.toString();
    }
}

