/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.signing;

import de.brendamour.jpasskit.signing.PKSigningException;
import de.brendamour.jpasskit.signing.PKSigningInformation;
import de.brendamour.jpasskit.util.CertUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class PKSigningInformationUtil {
    public PKSigningInformation loadSigningInformation(String keyStoreFilePath, String keyStorePassword, String appleWWDRCAFilePath) throws PKSigningException {
        try {
            return this.loadSigningInformationFromPKCS12AndIntermediateCertificate(keyStoreFilePath, keyStorePassword, appleWWDRCAFilePath);
        }
        catch (IOException | CertificateException e) {
            throw new PKSigningException("Failed to load signing information", e);
        }
    }

    public PKSigningInformation loadSigningInformationFromPKCS12AndIntermediateCertificate(String keyPath, String keyPassword, String appleWWDRCAFilePath) throws IOException, CertificateException {
        try (InputStream walletCertStream = CertUtils.toInputStream(keyPath);){
            PKSigningInformation pKSigningInformation;
            block12: {
                InputStream appleWWDRCertStream = CertUtils.toInputStream(appleWWDRCAFilePath);
                try {
                    KeyStore pkcs12KeyStore = this.loadPKCS12File(walletCertStream, keyPassword);
                    X509Certificate appleWWDRCert = this.loadDERCertificate(appleWWDRCertStream);
                    pKSigningInformation = this.loadSigningInformation(pkcs12KeyStore, keyPassword, appleWWDRCert);
                    if (appleWWDRCertStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (appleWWDRCertStream != null) {
                        try {
                            appleWWDRCertStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                appleWWDRCertStream.close();
            }
            return pKSigningInformation;
        }
    }

    public PKSigningInformation loadSigningInformationFromPKCS12AndIntermediateCertificate(InputStream keyStoreInputStream, String keyStorePassword, InputStream appleWWDRCAFileInputStream) throws IOException, CertificateException {
        KeyStore pkcs12KeyStore = this.loadPKCS12File(keyStoreInputStream, keyStorePassword);
        X509Certificate appleWWDRCACert = this.loadDERCertificate(appleWWDRCAFileInputStream);
        return this.loadSigningInformation(pkcs12KeyStore, keyStorePassword, appleWWDRCACert);
    }

    private PKSigningInformation loadSigningInformation(KeyStore keyStore, String keyStorePassword, X509Certificate appleWWDRCACert) throws IOException, CertificateException {
        ImmutablePair<PrivateKey, X509Certificate> pair = CertUtils.extractCertificateWithKey(keyStore, keyStorePassword.toCharArray());
        return this.checkCertsAndReturnSigningInformationObject((PrivateKey)pair.getLeft(), (X509Certificate)pair.getRight(), appleWWDRCACert);
    }

    @Deprecated
    public KeyStore loadPKCS12File(String pathToP12, String password) throws CertificateException, IOException {
        try (InputStream keystoreInputStream = CertUtils.toInputStream(pathToP12);){
            KeyStore keyStore = this.loadPKCS12File(keystoreInputStream, password);
            return keyStore;
        }
    }

    @Deprecated
    public KeyStore loadPKCS12File(InputStream inputStreamOfP12, String password) throws CertificateException, IOException {
        try {
            return CertUtils.toKeyStore(inputStreamOfP12, password.toCharArray());
        }
        catch (IllegalStateException ex) {
            throw new IOException("Key from the input stream could not be decrypted", ex);
        }
    }

    @Deprecated
    public X509Certificate loadDERCertificate(String filePath) throws IOException, CertificateException {
        try (InputStream certificateInputStream = CertUtils.toInputStream(filePath);){
            X509Certificate x509Certificate = this.loadDERCertificate(certificateInputStream);
            return x509Certificate;
        }
    }

    @Deprecated
    public X509Certificate loadDERCertificate(InputStream certificateInputStream) throws IOException, CertificateException {
        try {
            return CertUtils.toX509Certificate(certificateInputStream);
        }
        catch (IllegalStateException ex) {
            throw new IOException("Certificate from the input stream could not be decrypted", ex);
        }
    }

    private PKSigningInformation checkCertsAndReturnSigningInformationObject(PrivateKey signingPrivateKey, X509Certificate signingCert, X509Certificate appleWWDRCACert) throws IOException, CertificateException {
        if (signingCert == null || signingPrivateKey == null || appleWWDRCACert == null) {
            throw new IOException("Couldn't load all the necessary certificates/keys.");
        }
        appleWWDRCACert.checkValidity();
        signingCert.checkValidity();
        return new PKSigningInformation(signingCert, signingPrivateKey, appleWWDRCACert);
    }
}

