/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.personalization;

import de.brendamour.jpasskit.IPKBuilder;
import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.enums.PKPassPersonalizationField;
import de.brendamour.jpasskit.personalization.PKPersonalization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;

public class PKPersonalizationBuilder
implements IPKValidateable,
IPKBuilder<PKPersonalization> {
    private PKPersonalization personalization = new PKPersonalization();
    private List<PKPassPersonalizationField> requiredPersonalizationFields = new CopyOnWriteArrayList<PKPassPersonalizationField>();

    public List<PKPassPersonalizationField> getRequiredPersonalizationFields() {
        return this.requiredPersonalizationFields;
    }

    protected PKPersonalizationBuilder() {
    }

    public PKPersonalizationBuilder of(PKPersonalization source) {
        if (source != null) {
            this.personalization = source.clone();
            if (this.personalization.getRequiredPersonalizationFields() != null) {
                this.requiredPersonalizationFields = new CopyOnWriteArrayList<PKPassPersonalizationField>(this.personalization.getRequiredPersonalizationFields());
            }
        }
        return this;
    }

    public PKPersonalizationBuilder requiredPersonalizationField(PKPassPersonalizationField personalizationField) {
        if (personalizationField != null) {
            this.requiredPersonalizationFields.add(personalizationField);
        }
        return this;
    }

    public PKPersonalizationBuilder requiredPersonalizationFields(List<PKPassPersonalizationField> personalizationFields) {
        if (personalizationFields == null || personalizationFields.isEmpty()) {
            this.requiredPersonalizationFields.clear();
            return this;
        }
        this.requiredPersonalizationFields.addAll(personalizationFields);
        return this;
    }

    public PKPersonalizationBuilder description(String description) {
        this.personalization.description = description;
        return this;
    }

    public PKPersonalizationBuilder termsAndConditions(String termsAndConditions) {
        this.personalization.termsAndConditions = termsAndConditions;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    @Override
    public List<String> getValidationErrors() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.requiredPersonalizationFields == null || this.requiredPersonalizationFields.isEmpty()) {
            validationErrors.add("You need to provide at least one requiredPersonalizationField");
        }
        if (StringUtils.isEmpty((CharSequence)this.personalization.getDescription())) {
            validationErrors.add("You need to provide a description");
        }
        return validationErrors;
    }

    @Override
    public PKPersonalization build() {
        this.personalization.requiredPersonalizationFields = Collections.unmodifiableList(this.requiredPersonalizationFields);
        return this.personalization;
    }
}

