/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit;

import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import de.brendamour.jpasskit.IPKBuilder;
import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.PKBarcode;
import de.brendamour.jpasskit.PKBarcodeBuilder;
import de.brendamour.jpasskit.PKBeacon;
import de.brendamour.jpasskit.PKBeaconBuilder;
import de.brendamour.jpasskit.PKLocation;
import de.brendamour.jpasskit.PKLocationBuilder;
import de.brendamour.jpasskit.PKNFC;
import de.brendamour.jpasskit.PKPass;
import de.brendamour.jpasskit.PKRelevantDates;
import de.brendamour.jpasskit.PKRelevantDatesBuilder;
import de.brendamour.jpasskit.PKSemantics;
import de.brendamour.jpasskit.PKSemanticsBuilder;
import de.brendamour.jpasskit.PWAssociatedApp;
import de.brendamour.jpasskit.PWAssociatedAppBuilder;
import de.brendamour.jpasskit.enums.PKPassType;
import de.brendamour.jpasskit.passes.PKBoardingPass;
import de.brendamour.jpasskit.passes.PKGenericPass;
import de.brendamour.jpasskit.passes.PKGenericPassBuilder;
import de.brendamour.jpasskit.util.BuilderUtils;
import java.awt.Color;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonPOJOBuilder(withPrefix="")
public class PKPassBuilder
implements IPKValidateable,
IPKBuilder<PKPass> {
    private static final int EXPECTED_AUTHTOKEN_LENGTH = 16;
    private PKPass pkPass = new PKPass();
    private PKGenericPassBuilder pass = PKGenericPass.builder();
    protected List<PKBeaconBuilder> beacons = new CopyOnWriteArrayList<PKBeaconBuilder>();
    protected List<PKLocationBuilder> locations = new CopyOnWriteArrayList<PKLocationBuilder>();
    protected List<PKBarcodeBuilder> barcodes = new CopyOnWriteArrayList<PKBarcodeBuilder>();
    protected List<PWAssociatedAppBuilder> associatedApps = new CopyOnWriteArrayList<PWAssociatedAppBuilder>();
    protected List<Long> associatedStoreIdentifiers = new CopyOnWriteArrayList<Long>();

    protected PKPassBuilder() {
    }

    public List<PKBeaconBuilder> getBeaconBuilders() {
        return this.beacons;
    }

    public List<PKLocationBuilder> getLocationBuilders() {
        return this.locations;
    }

    public List<PKBarcodeBuilder> getBarcodeBuilders() {
        return this.barcodes;
    }

    public List<Long> getAssociatedStoreIdentifiers() {
        return this.associatedStoreIdentifiers;
    }

    public List<PWAssociatedAppBuilder> getAssociatedAppBuilders() {
        return this.associatedApps;
    }

    public PKGenericPassBuilder getPassBuilder() {
        return this.pass;
    }

    public PKPassBuilder of(PKPass pass) {
        if (pass != null) {
            this.pkPass = pass.clone();
            if (pass.getGeneric() != null) {
                this.pkPass.generic = null;
                this.pass(pass.getGeneric());
            }
            if (pass.getBoardingPass() != null) {
                this.pkPass.boardingPass = null;
                this.pass(pass.getBoardingPass());
            }
            if (pass.getCoupon() != null) {
                this.pkPass.coupon = null;
                this.pass(pass.getCoupon());
            }
            if (pass.getEventTicket() != null) {
                this.pkPass.eventTicket = null;
                this.pass(pass.getEventTicket());
            }
            if (pass.getStoreCard() != null) {
                this.pkPass.storeCard = null;
                this.pass(pass.getStoreCard());
            }
            this.beacons = BuilderUtils.toBeaconBuilderList(pass.getBeacons());
            this.locations = BuilderUtils.toLocationBuilderList(pass.getLocations());
            if (pass.relevantDates != null) {
                this.pkPass.relevantDates = pass.relevantDates.clone();
            }
            this.barcodes = BuilderUtils.toBarcodeBuilderList(pass.getBarcodes());
            this.associatedApps = BuilderUtils.toAssociatedAppBuilderList(pass.getAssociatedApps());
            if (pass.getAssociatedStoreIdentifiers() != null) {
                this.associatedStoreIdentifiers = new CopyOnWriteArrayList<Long>(pass.getAssociatedStoreIdentifiers());
            }
        }
        return this;
    }

    public PKPassBuilder serialNumber(String serialNumber) {
        this.pkPass.serialNumber = serialNumber;
        return this;
    }

    public PKPassBuilder passTypeIdentifier(String passTypeIdentifier) {
        this.pkPass.passTypeIdentifier = passTypeIdentifier;
        return this;
    }

    public PKPassBuilder webServiceURL(URL webServiceURL) {
        this.pkPass.webServiceURL = webServiceURL;
        return this;
    }

    public PKPassBuilder appLaunchURL(String appLaunchURL) {
        this.pkPass.appLaunchURL = appLaunchURL;
        return this;
    }

    public PKPassBuilder authenticationToken(String authenticationToken) {
        this.pkPass.authenticationToken = authenticationToken;
        return this;
    }

    public PKPassBuilder formatVersion(int formatVersion) {
        this.pkPass.formatVersion = formatVersion;
        return this;
    }

    public PKPassBuilder description(String description) {
        this.pkPass.description = description;
        return this;
    }

    public PKPassBuilder teamIdentifier(String teamIdentifier) {
        this.pkPass.teamIdentifier = teamIdentifier;
        return this;
    }

    public PKPassBuilder voided(boolean voided) {
        this.pkPass.voided = voided;
        return this;
    }

    public PKPassBuilder organizationName(String organizationName) {
        this.pkPass.organizationName = organizationName;
        return this;
    }

    public PKPassBuilder userInfo(Map<String, Object> userInfo) {
        this.pkPass.userInfo = userInfo;
        return this;
    }

    public PKPassBuilder logoText(String logoText) {
        this.pkPass.logoText = logoText;
        return this;
    }

    public PKPassBuilder foregroundColor(String foregroundColor) {
        this.pkPass.foregroundColor = foregroundColor;
        return this;
    }

    public PKPassBuilder foregroundColor(Color foregroundColor) {
        return this.foregroundColor(PKPassBuilder.convertColorToString(foregroundColor));
    }

    public PKPassBuilder backgroundColor(String backgroundColor) {
        this.pkPass.backgroundColor = backgroundColor;
        return this;
    }

    public PKPassBuilder backgroundColor(Color backgroundColor) {
        return this.backgroundColor(PKPassBuilder.convertColorToString(backgroundColor));
    }

    public PKPassBuilder beaconsBuilder(PKBeaconBuilder beacon) {
        if (beacon != null) {
            this.beacons.add(beacon);
        }
        return this;
    }

    public PKPassBuilder beacons(List<PKBeacon> beacons) {
        if (beacons == null || beacons.isEmpty()) {
            this.beacons.clear();
            return this;
        }
        beacons.stream().map(PKBeacon::builder).forEach(this::beaconsBuilder);
        return this;
    }

    public PKPassBuilder maxDistance(Long maxDistance) {
        this.pkPass.maxDistance = maxDistance;
        return this;
    }

    public PKPassBuilder locationBuilder(PKLocationBuilder location) {
        if (location != null) {
            this.locations.add(location);
        }
        return this;
    }

    public PKPassBuilder locations(List<PKLocation> locations) {
        if (locations == null || locations.isEmpty()) {
            this.locations.clear();
            return this;
        }
        locations.stream().map(PKLocation::builder).forEach(this::locationBuilder);
        return this;
    }

    public PKPassBuilder relevantDates(PKRelevantDates relevantDates) {
        this.pkPass.relevantDates = relevantDates;
        return this;
    }

    public PKPassBuilder relevantDatesBuilder(PKRelevantDatesBuilder relevantDatesBuilder) {
        return this.relevantDates(relevantDatesBuilder.build());
    }

    public PKPassBuilder barcodeBuilder(PKBarcodeBuilder barcode) {
        if (barcode != null) {
            this.barcodes.add(barcode);
        }
        return this;
    }

    public PKPassBuilder barcodes(List<PKBarcode> barcodes) {
        if (barcodes == null || barcodes.isEmpty()) {
            this.barcodes.clear();
            return this;
        }
        barcodes.stream().map(PKBarcode::builder).forEach(this::barcodeBuilder);
        return this;
    }

    public PKPassBuilder pass(PKGenericPassBuilder pass) {
        this.pass = pass;
        return this;
    }

    public PKPassBuilder pass(PKGenericPass generic) {
        return this.pass(PKGenericPass.builder(generic));
    }

    public PKPassBuilder pass(PKBoardingPass boardingPass) {
        return this.pass(PKBoardingPass.builder(boardingPass));
    }

    public PKPassBuilder labelColor(String labelColor) {
        this.pkPass.labelColor = labelColor;
        return this;
    }

    public PKPassBuilder labelColor(Color labelColor) {
        return this.labelColor(PKPassBuilder.convertColorToString(labelColor));
    }

    public PKPassBuilder groupingIdentifier(String groupingIdentifier) {
        this.pkPass.groupingIdentifier = groupingIdentifier;
        return this;
    }

    public PKPassBuilder associatedStoreIdentifier(Long associatedStoreIdentifier) {
        if (associatedStoreIdentifier != null) {
            this.associatedStoreIdentifiers.add(associatedStoreIdentifier);
        }
        return this;
    }

    public PKPassBuilder associatedStoreIdentifiers(List<Long> associatedStoreIdentifiers) {
        if (associatedStoreIdentifiers == null || associatedStoreIdentifiers.isEmpty()) {
            this.associatedStoreIdentifiers.clear();
            return this;
        }
        this.associatedStoreIdentifiers.addAll(associatedStoreIdentifiers);
        return this;
    }

    public PKPassBuilder associatedAppBuilder(PWAssociatedAppBuilder associatedApp) {
        if (associatedApp != null) {
            this.associatedApps.add(associatedApp);
        }
        return this;
    }

    public PKPassBuilder associatedApps(List<PWAssociatedApp> associatedApps) {
        if (associatedApps == null || associatedApps.isEmpty()) {
            this.associatedApps.clear();
            return this;
        }
        associatedApps.stream().map(PWAssociatedApp::builder).forEach(this::associatedAppBuilder);
        return this;
    }

    @Deprecated
    public PKPassBuilder relevantDate(Date relevantDate) {
        this.pkPass.relevantDate = relevantDate.toInstant();
        return this;
    }

    @Deprecated
    public PKPassBuilder expirationDate(Date expirationDate) {
        this.pkPass.expirationDate = expirationDate.toInstant();
        return this;
    }

    public PKPassBuilder relevantDate(Instant relevantInstant) {
        this.pkPass.relevantDate = relevantInstant;
        return this;
    }

    public PKPassBuilder expirationDate(Instant expirationInstant) {
        this.pkPass.expirationDate = expirationInstant;
        return this;
    }

    public PKPassBuilder nfc(PKNFC nfc) {
        this.pkPass.nfc = nfc;
        return this;
    }

    public PKPassBuilder sharingProhibited(boolean sharingProhibited) {
        this.pkPass.sharingProhibited = sharingProhibited;
        return this;
    }

    public PKPassBuilder semantics(PKSemantics semantics) {
        this.pkPass.semantics = semantics;
        return this;
    }

    public PKPassBuilder purchaseAdditionalBaggageURL(URL purchaseAdditionalBaggageURL) {
        this.pkPass.purchaseAdditionalBaggageURL = purchaseAdditionalBaggageURL;
        return this;
    }

    public PKPassBuilder purchaseLoungeAccessURL(URL purchaseLoungeAccessURL) {
        this.pkPass.purchaseLoungeAccessURL = purchaseLoungeAccessURL;
        return this;
    }

    public PKPassBuilder changeSeatURL(URL changeSeatURL) {
        this.pkPass.changeSeatURL = changeSeatURL;
        return this;
    }

    public PKPassBuilder purchaseWifiURL(URL purchaseWifiURL) {
        this.pkPass.purchaseWifiURL = purchaseWifiURL;
        return this;
    }

    public PKPassBuilder orderFoodURL(URL orderFoodURL) {
        this.pkPass.orderFoodURL = orderFoodURL;
        return this;
    }

    public PKPassBuilder entertainmentURL(URL entertainmentURL) {
        this.pkPass.entertainmentURL = entertainmentURL;
        return this;
    }

    public PKPassBuilder reportLostBagURL(URL reportLostBagURL) {
        this.pkPass.reportLostBagURL = reportLostBagURL;
        return this;
    }

    public PKPassBuilder managementURL(URL managementURL) {
        this.pkPass.managementURL = managementURL;
        return this;
    }

    public PKPassBuilder transitProviderPhoneNumber(String transitProviderPhoneNumber) {
        this.pkPass.transitProviderPhoneNumber = transitProviderPhoneNumber;
        return this;
    }

    public PKPassBuilder transitProviderEmail(String transitProviderEmail) {
        this.pkPass.transitProviderEmail = transitProviderEmail;
        return this;
    }

    public PKPassBuilder transitProviderWebsiteUrl(URL transitProviderWebsiteUrl) {
        this.pkPass.transitProviderWebsiteUrl = transitProviderWebsiteUrl;
        return this;
    }

    public PKPassBuilder upgradeURL(URL upgradeURL) {
        this.pkPass.upgradeURL = upgradeURL;
        return this;
    }

    public PKPassBuilder bagPolicyURL(URL bagPolicyURL) {
        this.pkPass.bagPolicyURL = bagPolicyURL;
        return this;
    }

    public PKPassBuilder accessibilityURL(URL accessibilityURL) {
        this.pkPass.accessibilityURL = accessibilityURL;
        return this;
    }

    public PKPassBuilder requestWheelchairURL(URL requestWheelchairURL) {
        this.pkPass.requestWheelchairURL = requestWheelchairURL;
        return this;
    }

    public PKPassBuilder registerServiceAnimalURL(URL registerServiceAnimalURL) {
        this.pkPass.registerServiceAnimalURL = registerServiceAnimalURL;
        return this;
    }

    public PKPassBuilder preferredStyleSchemes(List<String> preferredStyleSchemes) {
        this.pkPass.preferredStyleSchemes = preferredStyleSchemes;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    @Override
    public List<String> getValidationErrors() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        this.checkRequiredFields(validationErrors);
        this.checkAuthToken(validationErrors);
        this.checkPass(validationErrors);
        this.checkAssociatedAppIfSet(validationErrors);
        this.checkGroupingIdentifierIsOnlySetWhenAllowed(validationErrors);
        this.checkSemanticsIfSet(validationErrors);
        return validationErrors;
    }

    private void checkGroupingIdentifierIsOnlySetWhenAllowed(List<String> validationErrors) {
        if (StringUtils.isNotEmpty((CharSequence)this.pkPass.groupingIdentifier) && this.pass.getPassType() == PKPassType.PKEventTicket && this.pass.getPassType() == PKPassType.PKBoardingPass) {
            validationErrors.add("The groupingIdentifier is optional for event tickets and boarding passes, otherwise not allowed");
        }
    }

    private void checkAssociatedAppIfSet(List<String> validationErrors) {
        if (this.pkPass.appLaunchURL != null && BuilderUtils.isEmpty(this.associatedStoreIdentifiers)) {
            validationErrors.add("The appLaunchURL requires associatedStoreIdentifiers to be specified");
        }
    }

    private void checkPass(List<String> validationErrors) {
        if (this.pass == null) {
            validationErrors.add("No pass was defined");
        } else if (!this.pass.isValid()) {
            validationErrors.addAll(this.pass.getValidationErrors());
        }
    }

    private void checkAuthToken(List<String> validationErrors) {
        if (this.pkPass.authenticationToken != null && this.pkPass.authenticationToken.length() < 16) {
            validationErrors.add("The authenticationToken needs to be at least 16 long");
        }
    }

    private void checkRequiredFields(List<String> validationErrors) {
        if (StringUtils.isEmpty((CharSequence)this.pkPass.serialNumber) || StringUtils.isEmpty((CharSequence)this.pkPass.passTypeIdentifier) || StringUtils.isEmpty((CharSequence)this.pkPass.teamIdentifier) || StringUtils.isEmpty((CharSequence)this.pkPass.description) || this.pkPass.formatVersion == 0 || StringUtils.isEmpty((CharSequence)this.pkPass.organizationName)) {
            validationErrors.add("Not all required Fields are set. SerialNumber" + this.pkPass.serialNumber + " PassTypeIdentifier: " + this.pkPass.passTypeIdentifier + " teamIdentifier" + this.pkPass.teamIdentifier + " Description: " + this.pkPass.description + " FormatVersion: " + this.pkPass.formatVersion + " OrganizationName: " + this.pkPass.organizationName);
        }
    }

    private void checkSemanticsIfSet(List<String> validationErrors) {
        if (this.pkPass.semantics != null) {
            PKSemanticsBuilder semanticsBuilder = new PKSemanticsBuilder().of(this.pkPass.semantics);
            validationErrors.addAll(semanticsBuilder.getValidationErrors());
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private static String convertColorToString(Color color) {
        if (color != null) {
            return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        }
        return null;
    }

    @Override
    public PKPass build() {
        if (this.pass.getPassType() == null) {
            this.pkPass.generic = this.pass.build();
        } else {
            switch (this.pass.getPassType()) {
                case PKBoardingPass: {
                    this.pkPass.boardingPass = this.pass.buildBoardingPass();
                    break;
                }
                case PKCoupon: {
                    this.pkPass.coupon = this.pass.buildCoupon();
                    break;
                }
                case PKEventTicket: {
                    this.pkPass.eventTicket = this.pass.buildEventTicket();
                    break;
                }
                case PKStoreCard: {
                    this.pkPass.storeCard = this.pass.buildStoreCard();
                    break;
                }
                default: {
                    this.pkPass.generic = this.pass.build();
                }
            }
        }
        this.pkPass.beacons = BuilderUtils.buildAll(this.beacons);
        this.pkPass.locations = BuilderUtils.buildAll(this.locations);
        this.pkPass.barcodes = BuilderUtils.buildAll(this.barcodes);
        this.pkPass.associatedApps = BuilderUtils.buildAll(this.associatedApps);
        this.pkPass.associatedStoreIdentifiers = Collections.unmodifiableList(this.associatedStoreIdentifiers);
        return this.pkPass;
    }
}

