/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.signing;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import de.brendamour.jpasskit.PKBarcode;
import de.brendamour.jpasskit.PKPass;
import de.brendamour.jpasskit.signing.PKSigningInformation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public final class PKSigningUtil {
    private static final int ZIP_BUFFER_SIZE = 8192;
    private static final String FILE_SEPARATOR_UNIX = "/";
    private static final String MANIFEST_JSON_FILE_NAME = "manifest.json";
    private static final String PASS_JSON_FILE_NAME = "pass.json";
    private static PKSigningUtil instance = new PKSigningUtil();

    private PKSigningUtil() {
        this.addBCProvider();
    }

    public static PKSigningUtil getInstance() {
        return instance;
    }

    public byte[] createSignedAndZippedPkPassArchive(PKPass pass, URL fileUrlOfTemplateDirectory, PKSigningInformation signingInformation) throws Exception {
        String pathToTemplateDirectory = URLDecoder.decode(fileUrlOfTemplateDirectory.getFile(), "UTF-8");
        return this.createSignedAndZippedPkPassArchive(pass, pathToTemplateDirectory, signingInformation);
    }

    public byte[] createSignedAndZippedPkPassArchive(PKPass pass, String pathToTemplateDirectory, PKSigningInformation signingInformation) throws Exception {
        File tempPassDir = Files.createTempDir();
        FileUtils.copyDirectory((File)new File(pathToTemplateDirectory), (File)tempPassDir);
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        jsonObjectMapper.setDateFormat((DateFormat)new ISO8601DateFormat());
        this.createPassJSONFile(pass, tempPassDir, jsonObjectMapper);
        File manifestJSONFile = this.createManifestJSONFile(tempPassDir, jsonObjectMapper);
        this.signManifestFile(tempPassDir, manifestJSONFile, signingInformation);
        byte[] zippedPass = this.createZippedPassAndReturnAsByteArray(tempPassDir);
        FileUtils.deleteDirectory((File)tempPassDir);
        return zippedPass;
    }

    public void signManifestFile(File temporaryPassDirectory, File manifestJSONFile, PKSigningInformation signingInformation) throws Exception {
        if (temporaryPassDirectory == null || manifestJSONFile == null || signingInformation == null || !signingInformation.isValid()) {
            throw new IllegalArgumentException("Null params are not supported");
        }
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(signingInformation.getSigningPrivateKey());
        ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
        Attribute signingAttribute = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new DERUTCTime(new Date())));
        signedAttributes.add((ASN1Encodable)signingAttribute);
        AttributeTable signedAttributesTable = new AttributeTable(signedAttributes);
        DefaultSignedAttributeTableGenerator signedAttributeGenerator = new DefaultSignedAttributeTableGenerator(signedAttributesTable);
        generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).setSignedAttributeGenerator((CMSAttributeTableGenerator)signedAttributeGenerator).build(sha1Signer, signingInformation.getSigningCert()));
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(signingInformation.getAppleWWDRCACert());
        certList.add(signingInformation.getSigningCert());
        JcaCertStore certs = new JcaCertStore(certList);
        generator.addCertificates((Store)certs);
        CMSSignedData sigData = generator.generate((CMSTypedData)new CMSProcessableFile(manifestJSONFile), false);
        byte[] signedDataBytes = sigData.getEncoded();
        File signatureFile = new File(temporaryPassDirectory.getAbsolutePath() + File.separator + "signature");
        FileOutputStream signatureOutputStream = new FileOutputStream(signatureFile);
        signatureOutputStream.write(signedDataBytes);
        signatureOutputStream.close();
    }

    public PKSigningInformation loadSigningInformationFromPKCS12FileAndIntermediateCertificateFile(String pkcs12KeyStoreFilePath, String keyStorePassword, String appleWWDRCAFilePath) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, NoSuchProviderException, UnrecoverableKeyException {
        KeyStore pkcs12KeyStore = this.loadPKCS12File(pkcs12KeyStoreFilePath, keyStorePassword);
        Enumeration<String> aliases = pkcs12KeyStore.aliases();
        PrivateKey signingPrivateKey = null;
        X509Certificate signingCert = null;
        while (aliases.hasMoreElements()) {
            String aliasName = aliases.nextElement();
            Key key = pkcs12KeyStore.getKey(aliasName, keyStorePassword.toCharArray());
            if (!(key instanceof PrivateKey)) continue;
            signingPrivateKey = (PrivateKey)key;
            Certificate cert = pkcs12KeyStore.getCertificate(aliasName);
            if (!(cert instanceof X509Certificate)) continue;
            signingCert = (X509Certificate)cert;
            break;
        }
        X509Certificate appleWWDRCACert = this.loadDERCertificate(appleWWDRCAFilePath);
        if (signingCert == null || signingPrivateKey == null || appleWWDRCACert == null) {
            throw new IOException("Couldn#t load all the neccessary certificates/keys");
        }
        appleWWDRCACert.checkValidity();
        signingCert.checkValidity();
        return new PKSigningInformation(signingCert, signingPrivateKey, appleWWDRCACert);
    }

    public PKSigningInformation loadSigningInformationFromPKCS12AndIntermediateCertificateStreams(InputStream pkcs12KeyStoreInputStream, String keyStorePassword, InputStream appleWWDRCAFileInputStream) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, NoSuchProviderException, UnrecoverableKeyException {
        KeyStore pkcs12KeyStore = this.loadPKCS12File(pkcs12KeyStoreInputStream, keyStorePassword);
        Enumeration<String> aliases = pkcs12KeyStore.aliases();
        PrivateKey signingPrivateKey = null;
        X509Certificate signingCert = null;
        while (aliases.hasMoreElements()) {
            String aliasName = aliases.nextElement();
            Key key = pkcs12KeyStore.getKey(aliasName, keyStorePassword.toCharArray());
            if (!(key instanceof PrivateKey)) continue;
            signingPrivateKey = (PrivateKey)key;
            Certificate cert = pkcs12KeyStore.getCertificate(aliasName);
            if (!(cert instanceof X509Certificate)) continue;
            signingCert = (X509Certificate)cert;
            break;
        }
        X509Certificate appleWWDRCACert = this.loadDERCertificate(appleWWDRCAFileInputStream);
        if (signingCert == null || signingPrivateKey == null || appleWWDRCACert == null) {
            throw new IOException("Couldn#t load all the neccessary certificates/keys");
        }
        appleWWDRCACert.checkValidity();
        return new PKSigningInformation(signingCert, signingPrivateKey, appleWWDRCACert);
    }

    public KeyStore loadPKCS12File(String pathToP12, String password) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, NoSuchProviderException {
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        File p12File = new File(pathToP12);
        if (!p12File.exists()) {
            URL localP12File = PKSigningUtil.class.getClassLoader().getResource(pathToP12);
            if (localP12File == null) {
                throw new FileNotFoundException("File at " + pathToP12 + " not found");
            }
            p12File = new File(localP12File.getFile());
        }
        FileInputStream streamOfFile = new FileInputStream(p12File);
        keystore.load(streamOfFile, password.toCharArray());
        IOUtils.closeQuietly((InputStream)streamOfFile);
        return keystore;
    }

    public KeyStore loadPKCS12File(InputStream inputStreamOfP12, String password) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, NoSuchProviderException {
        if (inputStreamOfP12 == null) {
            throw new IllegalArgumentException("InputStream of key store must not be null");
        }
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(inputStreamOfP12, password.toCharArray());
        return keystore;
    }

    public X509Certificate loadDERCertificate(String filePath) throws IOException, CertificateException {
        FileInputStream certificateFileInputStream;
        block8: {
            certificateFileInputStream = null;
            File certFile = new File(filePath);
            if (!certFile.exists()) {
                URL localCertFile = PKSigningUtil.class.getClassLoader().getResource(filePath);
                if (localCertFile == null) {
                    throw new FileNotFoundException("File at " + filePath + " not found");
                }
                certFile = new File(localCertFile.getFile());
            }
            certificateFileInputStream = new FileInputStream(certFile);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            Certificate certificate = certificateFactory.generateCertificate(certificateFileInputStream);
            if (!(certificate instanceof X509Certificate)) break block8;
            ((X509Certificate)certificate).checkValidity();
            X509Certificate x509Certificate = (X509Certificate)certificate;
            IOUtils.closeQuietly((InputStream)certificateFileInputStream);
            return x509Certificate;
        }
        try {
            try {
                throw new IOException("The key from '" + filePath + "' could not be decrypted");
            }
            catch (IOException ex) {
                throw new IOException("The key from '" + filePath + "' could not be decrypted", ex);
            }
            catch (NoSuchProviderException ex) {
                throw new IOException("The key from '" + filePath + "' could not be decrypted", ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(certificateFileInputStream);
            throw throwable;
        }
    }

    public X509Certificate loadDERCertificate(InputStream certificateInputStream) throws IOException, CertificateException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            Certificate certificate = certificateFactory.generateCertificate(certificateInputStream);
            if (certificate instanceof X509Certificate) {
                ((X509Certificate)certificate).checkValidity();
                return (X509Certificate)certificate;
            }
            throw new IOException("The key from the input stream could not be decrypted");
        }
        catch (IOException ex) {
            throw new IOException("The key from the input stream could not be decrypted", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new IOException("The key from the input stream could not be decrypted", ex);
        }
    }

    private void addBCProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private void createPassJSONFile(PKPass pass, File tempPassDir, ObjectMapper jsonObjectMapper) throws IOException, JsonGenerationException, JsonMappingException {
        File passJSONFile = new File(tempPassDir.getAbsolutePath() + File.separator + PASS_JSON_FILE_NAME);
        ObjectWriter objectWriter = this.getObjectWriterWithFilters(jsonObjectMapper);
        objectWriter.writeValue(passJSONFile, (Object)pass);
    }

    private File createManifestJSONFile(File tempPassDir, ObjectMapper jsonObjectMapper) throws IOException, JsonGenerationException, JsonMappingException {
        HashMap<String, String> fileWithHashMap = new HashMap<String, String>();
        HashFunction hashFunction = Hashing.sha1();
        File[] filesInTempDir = tempPassDir.listFiles();
        this.hashFilesInDirectory(filesInTempDir, fileWithHashMap, hashFunction, null);
        File manifestJSONFile = new File(tempPassDir.getAbsolutePath() + File.separator + MANIFEST_JSON_FILE_NAME);
        ObjectWriter objectWriter = this.getObjectWriterWithFilters(jsonObjectMapper);
        objectWriter.writeValue(manifestJSONFile, fileWithHashMap);
        return manifestJSONFile;
    }

    private ObjectWriter getObjectWriterWithFilters(ObjectMapper jsonObjectMapper) {
        SimpleFilterProvider filters = new SimpleFilterProvider();
        filters.addFilter("validateFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"valid", "validationErrors"}));
        filters.addFilter("pkPassFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"valid", "validationErrors", "foregroundColorAsObject", "backgroundColorAsObject", "labelColorAsObject", "passThatWasSet"}));
        filters.addFilter("barcodeFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"valid", "validationErrors", "messageEncodingAsString"}));
        filters.addFilter("charsetFilter", SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"name"}));
        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonObjectMapper.addMixIn(Object.class, ValidateFilterMixIn.class);
        jsonObjectMapper.addMixIn(PKPass.class, PkPassFilterMixIn.class);
        jsonObjectMapper.addMixIn(PKBarcode.class, BarcodeFilterMixIn.class);
        jsonObjectMapper.addMixIn(Charset.class, CharsetFilterMixIn.class);
        ObjectWriter objectWriter = jsonObjectMapper.writer((FilterProvider)filters);
        return objectWriter;
    }

    private void hashFilesInDirectory(File[] files, Map<String, String> fileWithHashMap, HashFunction hashFunction, String parentName) throws IOException {
        for (File passResourceFile : files) {
            StringBuilder name = new StringBuilder();
            if (passResourceFile.isFile()) {
                HashCode hash = Files.hash((File)passResourceFile, (HashFunction)hashFunction);
                if (StringUtils.isEmpty((CharSequence)parentName)) {
                    name.append(passResourceFile.getName());
                } else {
                    name.append(parentName);
                    name.append(FILE_SEPARATOR_UNIX);
                    name.append(passResourceFile.getName());
                }
                fileWithHashMap.put(name.toString(), Hex.encodeHexString((byte[])hash.asBytes()));
                continue;
            }
            if (!passResourceFile.isDirectory()) continue;
            if (StringUtils.isEmpty((CharSequence)parentName)) {
                name.append(passResourceFile.getName());
            } else {
                name.append(parentName);
                name.append(FILE_SEPARATOR_UNIX);
                name.append(passResourceFile.getName());
            }
            this.hashFilesInDirectory(passResourceFile.listFiles(), fileWithHashMap, hashFunction, name.toString());
        }
    }

    private byte[] createZippedPassAndReturnAsByteArray(File tempPassDir) throws IOException {
        ByteArrayOutputStream byteArrayOutputStreamForZippedPass = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStreamForZippedPass);
        this.zip(tempPassDir, tempPassDir, zipOutputStream);
        zipOutputStream.close();
        return byteArrayOutputStreamForZippedPass.toByteArray();
    }

    private final void zip(File directory, File base, ZipOutputStream zipOutputStream) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                this.zip(files[i], base, zipOutputStream);
                continue;
            }
            FileInputStream fileInputStream = new FileInputStream(files[i]);
            ZipEntry entry = new ZipEntry(this.getRelativePathOfZipEntry(files[i], base));
            zipOutputStream.putNextEntry(entry);
            while (-1 != (read = fileInputStream.read(buffer))) {
                zipOutputStream.write(buffer, 0, read);
            }
            fileInputStream.close();
        }
    }

    private String getRelativePathOfZipEntry(File fileToZip, File base) {
        String relativePathOfFile = fileToZip.getPath().substring(base.getPath().length() + 1);
        if (File.separatorChar != '/') {
            relativePathOfFile = relativePathOfFile.replace(File.separatorChar, '/');
        }
        return relativePathOfFile;
    }

    @JsonFilter(value="charsetFilter")
    private class CharsetFilterMixIn {
        private CharsetFilterMixIn() {
        }
    }

    @JsonFilter(value="barcodeFilter")
    private class BarcodeFilterMixIn {
        private BarcodeFilterMixIn() {
        }
    }

    @JsonFilter(value="validateFilter")
    private class ValidateFilterMixIn {
        private ValidateFilterMixIn() {
        }
    }

    @JsonFilter(value="pkPassFilter")
    private class PkPassFilterMixIn {
        private PkPassFilterMixIn() {
        }
    }
}

