/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.apns;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.DeliveryError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKSendPushNotificationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKSendPushNotificationUtil.class);
    private static final String EMPTY_PUSH_JSON_STRING = "{}";
    private ApnsService service;

    public PKSendPushNotificationUtil(String pathToP12, String passwordForP12) throws FileNotFoundException {
        this(pathToP12, passwordForP12, 10);
    }

    public PKSendPushNotificationUtil(String pathToP12, String passwordForP12, int poolSize) throws FileNotFoundException {
        InputStream certificateStream = this.getStreamOfP12File(pathToP12);
        this.service = APNS.newService().withCert(certificateStream, passwordForP12).withProductionDestination().withDelegate((ApnsDelegate)new ApnsLoggingDelegate()).asPool(poolSize).build();
    }

    private InputStream getStreamOfP12File(String pathToP12) throws FileNotFoundException {
        File p12File = new File(pathToP12);
        if (!p12File.exists()) {
            URL localP12File = this.getClass().getClassLoader().getResource(pathToP12);
            if (localP12File == null) {
                throw new FileNotFoundException("File at " + pathToP12 + " not found");
            }
            p12File = new File(localP12File.getFile());
        }
        return new FileInputStream(p12File);
    }

    public void sendPushNotification(String pushtoken) {
        LOGGER.debug("Sending Push notification for key: {}", (Object)pushtoken);
        this.service.push(pushtoken, EMPTY_PUSH_JSON_STRING);
        LOGGER.debug("Send Push notification for key: {}", (Object)pushtoken);
    }

    public void sendMultiplePushNotifications(List<String> pushtokens) {
        LOGGER.debug("Sending Push notification for keys: {}", pushtokens);
        this.service.push(pushtokens, EMPTY_PUSH_JSON_STRING);
        LOGGER.debug("Send Push notification for keys: {}", pushtokens);
    }

    public Map<String, Date> getInactiveDevices() {
        LOGGER.debug("Querying inactive devices");
        Map inactiveDevices = this.service.getInactiveDevices();
        LOGGER.debug("Inactive devices: {}", (Object)inactiveDevices);
        return inactiveDevices;
    }

    class ApnsLoggingDelegate
    implements ApnsDelegate {
        ApnsLoggingDelegate() {
        }

        public void messageSendFailed(ApnsNotification message, Throwable e) {
            LOGGER.debug("Message failed: {}", (Object)message, (Object)e);
        }

        public void connectionClosed(DeliveryError e, int messageIdentifier) {
            LOGGER.debug("Connection closed: {}", (Object)messageIdentifier, (Object)e);
        }

        public void cacheLengthExceeded(int newCacheLength) {
            LOGGER.debug("CacheLengthExceeded: {}", (Object)newCacheLength);
        }

        public void messageSent(ApnsNotification message, boolean resent) {
            LOGGER.debug("Message sent: {} (resent={})", (Object)message, (Object)resent);
        }

        public void notificationsResent(int resendCount) {
            LOGGER.debug("Messages resent: {}", (Object)resendCount);
        }
    }
}

