/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.validation;

import de.bechte.junit.runners.validation.TestClassValidator;
import java.lang.annotation.Annotation;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FixtureValidator implements TestClassValidator
{
    BEFORE_CLASS_METHODS(BeforeClass.class, true),
    AFTER_CLASS_METHODS(AfterClass.class, true),
    BEFORE_METHODS(Before.class, false),
    AFTER_METHODS(After.class, false),
    TEST_METHODS(Test.class, false);

    private Class<? extends Annotation> annotationClass;
    private boolean isStatic;

    private FixtureValidator(Class<? extends Annotation> annotationClass, boolean isStatic) {
        this.annotationClass = annotationClass;
        this.isStatic = isStatic;
    }

    @Override
    public void validate(TestClass testClass, List<Throwable> errors) {
        List methods = testClass.getAnnotatedMethods(this.annotationClass);
        for (FrameworkMethod method : methods) {
            method.validatePublicVoidNoArg(this.isStatic, errors);
        }
    }
}

