/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context;

import de.bechte.junit.runners.context.description.ContextDescriber;
import de.bechte.junit.runners.context.description.Describer;
import de.bechte.junit.runners.context.description.MethodDescriber;
import de.bechte.junit.runners.context.processing.ChildExecutor;
import de.bechte.junit.runners.context.processing.ChildResolver;
import de.bechte.junit.runners.context.processing.ContextExecutor;
import de.bechte.junit.runners.context.processing.ContextResolver;
import de.bechte.junit.runners.context.processing.MethodExecutor;
import de.bechte.junit.runners.context.processing.MethodResolver;
import de.bechte.junit.runners.context.statements.RunAll;
import de.bechte.junit.runners.context.statements.RunChildren;
import de.bechte.junit.runners.context.statements.StatementExecutor;
import de.bechte.junit.runners.context.statements.StatementExecutorFactory;
import de.bechte.junit.runners.context.statements.builder.ClassStatementBuilder;
import de.bechte.junit.runners.context.statements.builder.StatementBuilderFactory;
import de.bechte.junit.runners.model.TestClassPool;
import de.bechte.junit.runners.validation.BooleanValidator;
import de.bechte.junit.runners.validation.ChildrenCountValidator;
import de.bechte.junit.runners.validation.ConstructorValidator;
import de.bechte.junit.runners.validation.FixtureValidator;
import de.bechte.junit.runners.validation.RuleValidator;
import de.bechte.junit.runners.validation.TestClassValidator;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalContextRunner
extends Runner {
    protected final TestClass testClass;
    protected ChildResolver<FrameworkMethod> methodResolver;
    protected Describer<FrameworkMethod> methodDescriber;
    protected ChildExecutor<FrameworkMethod> methodRunner;
    protected ChildResolver<Class<?>> contextResolver;
    protected Describer<Class<?>> contextDescriber;
    protected ChildExecutor<Class<?>> contextRunner;
    protected StatementExecutor statementExecutor;
    protected List<ClassStatementBuilder> statementBuilders;

    public HierarchicalContextRunner(Class<?> testClass) throws InitializationError {
        this.testClass = TestClassPool.forClass(testClass);
        this.validate();
        this.initialize();
    }

    private void validate() throws InitializationError {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.getValidator().validate(this.testClass, errors);
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    protected TestClassValidator getValidator() {
        return BooleanValidator.AND(ConstructorValidator.VALID_CONSTRUCTOR, BooleanValidator.OR(ChildrenCountValidator.CONTEXT_HIERARCHIES, ChildrenCountValidator.TEST_METHODS), FixtureValidator.BEFORE_CLASS_METHODS, FixtureValidator.AFTER_CLASS_METHODS, FixtureValidator.BEFORE_METHODS, FixtureValidator.AFTER_METHODS, FixtureValidator.TEST_METHODS, RuleValidator.CLASS_RULE_VALIDATOR, RuleValidator.CLASS_RULE_METHOD_VALIDATOR, RuleValidator.RULE_VALIDATOR, RuleValidator.RULE_METHOD_VALIDATOR);
    }

    protected void initialize() {
        StatementExecutorFactory statementExecutorFactory = StatementExecutorFactory.getDefault();
        StatementBuilderFactory statementBuilderFactory = StatementBuilderFactory.getDefault();
        this.methodResolver = new MethodResolver();
        this.methodDescriber = new MethodDescriber();
        this.methodRunner = new MethodExecutor(this.methodDescriber, statementExecutorFactory.getExecutorForMethods(), statementBuilderFactory.getBuildersForMethods());
        this.contextResolver = new ContextResolver();
        this.contextDescriber = new ContextDescriber(this.contextResolver, this.methodResolver, this.methodDescriber);
        this.contextRunner = new ContextExecutor(this.contextDescriber);
        this.statementExecutor = statementExecutorFactory.getExecutorForClasses();
        this.statementBuilders = statementBuilderFactory.getBuildersForClasses();
    }

    public Description getDescription() {
        return this.contextDescriber.describe(this.testClass.getJavaClass());
    }

    public void run(RunNotifier notifier) {
        Description description = this.getDescription();
        Statement statement = this.runChildren(description, notifier);
        for (ClassStatementBuilder builder : this.statementBuilders) {
            statement = builder.createStatement(this.testClass, statement, description, notifier);
        }
        this.statementExecutor.execute(statement, notifier, description);
    }

    protected Statement runChildren(Description description, RunNotifier notifier) {
        return new RunAll(new RunChildren<FrameworkMethod>(this.testClass, this.methodRunner, this.methodResolver, notifier), new RunChildren(this.testClass, this.contextRunner, this.contextResolver, notifier));
    }
}

