/*
 * Decompiled with CFR 0.152.
 */
package de.atextor.turtle.formatter;

import de.atextor.turtle.formatter.FormattingStyle;
import de.atextor.turtle.formatter.RDFNodeComparatorFactory;
import de.atextor.turtle.formatter.blanknode.BlankNodeMetadata;
import de.atextor.turtle.formatter.blanknode.BlankNodeOrderAwareTurtleParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.irix.IRIException;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurtleFormatter
implements Function<Model, String>,
BiConsumer<Model, OutputStream> {
    public static final String OUTPUT_ERROR_MESSAGE = "Could not write to stream";
    public static final String DEFAULT_EMPTY_BASE = "urn:turtleformatter:internal";
    private static final Logger LOG = LoggerFactory.getLogger(TurtleFormatter.class);
    private static final Pattern XSD_DECIMAL_UNQUOTED_REGEX = Pattern.compile("[+-]?\\d*\\.\\d+");
    private static final Pattern XSD_DOUBLE_UNQUOTED_REGEX = Pattern.compile("(([+-]?\\d+\\.\\d+)|([+-]?\\.\\d+)|([+-]?\\d+))[eE][+-]?\\d+");
    private static final Pattern STRING_ESCAPE_SEQUENCES = Pattern.compile("[\t\b\n\r\f\"\\\\]");
    private final FormattingStyle style;
    private final String beforeDot;
    private final String endOfLine;
    private final Charset encoding;
    private final Comparator<Map.Entry<String, String>> prefixOrder;
    private final Comparator<RDFNode> objectOrder;

    public TurtleFormatter(FormattingStyle style) {
        this.style = style;
        this.endOfLine = switch (style.endOfLine) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.EndOfLineStyle.CR -> "\r";
            case FormattingStyle.EndOfLineStyle.LF -> "\n";
            case FormattingStyle.EndOfLineStyle.CRLF -> "\r\n";
        };
        this.beforeDot = switch (style.beforeDot) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.GapStyle.SPACE -> " ";
            case FormattingStyle.GapStyle.NOTHING -> "";
            case FormattingStyle.GapStyle.NEWLINE -> this.endOfLine;
        };
        this.encoding = switch (style.charset) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.Charset.UTF_8, FormattingStyle.Charset.UTF_8_BOM -> StandardCharsets.UTF_8;
            case FormattingStyle.Charset.LATIN1 -> StandardCharsets.ISO_8859_1;
            case FormattingStyle.Charset.UTF_16_BE -> StandardCharsets.UTF_16BE;
            case FormattingStyle.Charset.UTF_16_LE -> StandardCharsets.UTF_16LE;
        };
        this.prefixOrder = Comparator.comparingInt(entry -> style.prefixOrder.contains(entry.getKey()) ? style.prefixOrder.indexOf(entry.getKey()) : Integer.MAX_VALUE).thenComparing(Map.Entry::getKey);
        this.objectOrder = Comparator.comparingInt(object -> style.objectOrder.contains(object) ? style.objectOrder.indexOf(object) : Integer.MAX_VALUE);
    }

    private static List<Statement> statements(Model model) {
        return model.listStatements().toList();
    }

    private static List<Statement> statements(Model model, Property predicate, RDFNode object) {
        return model.listStatements(null, predicate, object).toList();
    }

    @Override
    public String apply(Model model) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.accept(model, outputStream);
        return outputStream.toString();
    }

    public String applyToContent(String content) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.process(content, outputStream);
        return outputStream.toString();
    }

    private void process(String content, ByteArrayOutputStream outputStream) {
        if (this.style.charset == FormattingStyle.Charset.UTF_8_BOM) {
            this.writeByteOrderMark(outputStream);
        }
        BlankNodeOrderAwareTurtleParser.ParseResult result = BlankNodeOrderAwareTurtleParser.parseModel(content);
        Model model = result.getModel();
        BlankNodeMetadata blankNodeMetadata = result.getBlankNodeMetadata();
        PrefixMapping prefixMapping = this.buildPrefixMapping(model);
        RDFNodeComparatorFactory RDFNodeComparatorFactory2 = new RDFNodeComparatorFactory(prefixMapping, blankNodeMetadata);
        this.doFormat(model, outputStream, prefixMapping, RDFNodeComparatorFactory2, blankNodeMetadata);
    }

    private void writeByteOrderMark(OutputStream outputStream) {
        try {
            outputStream.write(new byte[]{-17, -69, -65});
        }
        catch (IOException exception) {
            LOG.error(OUTPUT_ERROR_MESSAGE, (Throwable)exception);
        }
    }

    @Override
    public void accept(Model model, OutputStream outputStream) {
        if (this.style.charset == FormattingStyle.Charset.UTF_8_BOM) {
            this.writeByteOrderMark(outputStream);
        }
        PrefixMapping prefixMapping = this.buildPrefixMapping(model);
        RDFNodeComparatorFactory RDFNodeComparatorFactory2 = new RDFNodeComparatorFactory(prefixMapping);
        this.doFormat(model, outputStream, prefixMapping, RDFNodeComparatorFactory2, BlankNodeMetadata.gotNothing());
    }

    private void doFormat(Model model, OutputStream outputStream, PrefixMapping prefixMapping, RDFNodeComparatorFactory RDFNodeComparatorFactory2, BlankNodeMetadata blankNodeMetadata) {
        Comparator<Property> predicateOrder = Comparator.comparingInt(property -> this.style.predicateOrder.contains(property) ? this.style.predicateOrder.indexOf(property) : Integer.MAX_VALUE).thenComparing(property -> prefixMapping.shortForm(property.getURI()));
        State initialState = this.buildInitialState(model, outputStream, prefixMapping, predicateOrder, RDFNodeComparatorFactory2, blankNodeMetadata);
        State prefixesWritten = this.writePrefixes(initialState);
        List<Statement> statements = this.determineStatements(model, RDFNodeComparatorFactory2);
        State namedResourcesWritten = this.writeNamedResources(prefixesWritten, statements);
        State allResourcesWritten = this.writeAnonymousResources(namedResourcesWritten);
        State finalState = this.style.insertFinalNewline ? allResourcesWritten.newLine() : allResourcesWritten;
        LOG.debug("Written {} resources, with {} named anonymous resources", (Object)finalState.visitedResources.size(), (Object)finalState.identifiedAnonymousResources.size());
    }

    private State writeAnonymousResources(State state) {
        State currentState = state;
        List<RDFNode> sortedAnonymousIdentifiedResources = state.identifiedAnonymousResources.keySet().stream().sorted(state.getRDFNodeComparatorFactory().comparator()).toList();
        for (Resource resource : sortedAnonymousIdentifiedResources) {
            if (!resource.listProperties().hasNext()) continue;
            currentState = this.writeSubject(resource, currentState.withIndentationLevel(0));
        }
        return currentState;
    }

    private State writeNamedResources(State state, List<Statement> statements) {
        State currentState = state;
        for (Statement statement : statements) {
            Resource resource = statement.getSubject();
            if (!resource.listProperties().hasNext() || currentState.visitedResources.contains(resource)) continue;
            if (resource.isURIResource()) {
                currentState = this.writeSubject(resource, currentState.withIndentationLevel(0));
                continue;
            }
            State resourceWritten = this.writeAnonymousResource(resource, currentState.withIndentationLevel(0));
            boolean omitSpaceBeforeDelimiter = !currentState.identifiedAnonymousResources.containsKey(resource);
            currentState = this.writeDot(resourceWritten, omitSpaceBeforeDelimiter).newLine();
        }
        return currentState;
    }

    private List<Statement> determineStatements(Model model, RDFNodeComparatorFactory rdfNodeComparatorFactory) {
        Stream wellKnownSubjects = this.style.subjectOrder.stream().flatMap(subjectType -> TurtleFormatter.statements(model, RDF.type, (RDFNode)subjectType).stream().sorted(Comparator.comparing(Statement::getSubject, rdfNodeComparatorFactory.comparator())));
        Stream<Statement> otherSubjects = TurtleFormatter.statements(model).stream().filter(statement -> !statement.getPredicate().equals(RDF.type) || !statement.getObject().isResource() || !this.style.subjectOrder.contains(statement.getObject().asResource())).sorted(Comparator.comparing(Statement::getSubject, rdfNodeComparatorFactory.comparator()));
        return Stream.concat(wellKnownSubjects, otherSubjects).filter(statement -> !statement.getSubject().isAnon() || !model.contains(null, null, (RDFNode)statement.getSubject())).toList();
    }

    private State buildInitialState(Model model, OutputStream outputStream, PrefixMapping prefixMapping, Comparator<Property> predicateOrder, RDFNodeComparatorFactory RDFNodeComparatorFactory2, BlankNodeMetadata blankNodeMetadata) {
        State currentState = new State(outputStream, model, predicateOrder, prefixMapping, RDFNodeComparatorFactory2, blankNodeMetadata);
        int i = 0;
        Set<String> blankNodeLabelsInInput = blankNodeMetadata.getAllBlankNodeLabels();
        for (Resource r : this.anonymousResourcesThatNeedAnId(model, currentState)) {
            String s = blankNodeMetadata.getLabel(r.asNode());
            if (s == null) {
                while (currentState.identifiedAnonymousResources.containsValue(s = this.style.anonymousNodeIdGenerator.apply(r, i++)) && blankNodeLabelsInInput.contains(s)) {
                }
            }
            currentState = currentState.withIdentifiedAnonymousResource(r, s);
        }
        return currentState;
    }

    private Set<Resource> anonymousResourcesThatNeedAnId(Model model, State currentState) {
        HashSet<Resource> identifiedResources = new HashSet<Resource>(currentState.identifiedAnonymousResources.keySet());
        Set candidates = model.listObjects().toList().stream().filter(RDFNode::isResource).map(RDFNode::asResource).filter(RDFNode::isAnon).collect(Collectors.toSet());
        candidates.removeAll(currentState.getBlankNodeMetadata().getLabeledBlankNodes());
        List<RDFNode> candidatesInOrder = Stream.concat(currentState.getBlankNodeMetadata().getLabeledBlankNodes().stream().sorted(currentState.getRDFNodeComparatorFactory().comparator()), candidates.stream().sorted(currentState.getRDFNodeComparatorFactory().comparator())).toList();
        for (Resource resource : candidatesInOrder) {
            if (identifiedResources.contains(resource) || TurtleFormatter.statements(model, null, (RDFNode)resource).size() <= 1 && !this.hasBlankNodeCycle(model, resource, identifiedResources)) continue;
            identifiedResources.add(resource);
        }
        identifiedResources.removeAll(currentState.identifiedAnonymousResources.keySet());
        return identifiedResources;
    }

    private boolean hasBlankNodeCycle(Model model, Resource start, Set<Resource> identifiedResources) {
        if (!start.isAnon()) {
            return false;
        }
        return this.hasBlankNodeCycle(model, start, start, identifiedResources, new HashSet<Resource>());
    }

    private boolean hasBlankNodeCycle(Model model, Resource resource, Resource target, Set<Resource> identifiedResources, Set<Resource> visited) {
        if (visited.contains(resource)) {
            return false;
        }
        visited.add(resource);
        return model.listStatements(resource, null, (RDFNode)null).toList().stream().map(Statement::getObject).filter(RDFNode::isAnon).map(RDFNode::asResource).filter(Predicate.not(identifiedResources::contains)).anyMatch(o -> target.equals(o) || this.hasBlankNodeCycle(model, (Resource)o, target, identifiedResources, visited));
    }

    private PrefixMapping buildPrefixMapping(Model model) {
        Map<String, String> prefixMap = this.style.knownPrefixes.stream().filter(knownPrefix -> model.getNsPrefixURI(knownPrefix.prefix()) == null).collect(Collectors.toMap(FormattingStyle.KnownPrefix::prefix, knownPrefix -> knownPrefix.iri().toString()));
        return PrefixMapping.Factory.create().setNsPrefixes(model.getNsPrefixMap()).setNsPrefixes(prefixMap);
    }

    private State writePrefixes(State state) {
        Map prefixes = state.prefixMapping.getNsPrefixMap();
        int maxPrefixLength = prefixes.keySet().stream().map(String::length).max(Integer::compareTo).orElse(0);
        String prefixFormat = switch (this.style.alignPrefixes) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.Alignment.OFF -> "@prefix %s: <%s>" + this.beforeDot + "." + this.endOfLine;
            case FormattingStyle.Alignment.LEFT -> "@prefix %-" + maxPrefixLength + "s: <%s>" + this.beforeDot + "." + this.endOfLine;
            case FormattingStyle.Alignment.RIGHT -> "@prefix %" + maxPrefixLength + "s: <%s>" + this.beforeDot + "." + this.endOfLine;
        };
        List<String> urisInModel = this.allUsedUris(state.model);
        List<Map.Entry> entries = prefixes.entrySet().stream().sorted(this.prefixOrder).filter(entry -> this.style.keepUnusedPrefixes || urisInModel.stream().anyMatch(resource -> resource.startsWith((String)entry.getValue()))).toList();
        State currentState = state;
        for (Map.Entry entry2 : entries) {
            currentState = currentState.write(String.format(prefixFormat, entry2.getKey(), entry2.getValue()));
        }
        currentState = currentState.newLine();
        return currentState;
    }

    private List<String> allUsedUris(Model model) {
        return model.listStatements().toList().stream().flatMap(statement -> Stream.of(statement.getSubject(), statement.getPredicate(), statement.getObject())).map(rdfNode -> {
            if (rdfNode.isURIResource()) {
                return Optional.of(rdfNode.asResource().getURI());
            }
            if (rdfNode.isLiteral()) {
                return Optional.of(rdfNode.asLiteral().getDatatypeURI());
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private String indent(int level) {
        String singleIndent = switch (this.style.indentStyle) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.IndentStyle.SPACE -> " ".repeat(this.style.indentSize);
            case FormattingStyle.IndentStyle.TAB -> "\t";
        };
        return singleIndent.repeat(Math.max(level, 0));
    }

    private String continuationIndent(int level) {
        String continuation = switch (this.style.indentStyle) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.IndentStyle.SPACE -> " ".repeat(this.style.continuationIndentSize);
            case FormattingStyle.IndentStyle.TAB -> "\t".repeat(2);
        };
        return this.indent(level - 1) + continuation;
    }

    private State writeDelimiter(String delimiter, FormattingStyle.GapStyle before, FormattingStyle.GapStyle after, String indentation, State state) {
        State beforeState = switch (before) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.GapStyle.SPACE -> {
                if (state.lastCharacter.equals(" ")) {
                    yield state;
                }
                yield state.write(" ");
            }
            case FormattingStyle.GapStyle.NOTHING -> state;
            case FormattingStyle.GapStyle.NEWLINE -> state.newLine().write(indentation);
        };
        return switch (after) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.GapStyle.SPACE -> beforeState.write(delimiter + " ");
            case FormattingStyle.GapStyle.NOTHING -> beforeState.write(delimiter);
            case FormattingStyle.GapStyle.NEWLINE -> beforeState.write(delimiter).newLine().write(indentation);
        };
    }

    private State writeComma(State state) {
        return this.writeDelimiter(",", this.style.beforeComma, this.style.afterComma, this.continuationIndent(state.indentationLevel), state);
    }

    private State writeSemicolon(State state, boolean omitLineBreak, boolean omitSpaceBeforeSemicolon, String nextLineIndentation) {
        FormattingStyle.GapStyle beforeSemicolon = omitSpaceBeforeSemicolon ? FormattingStyle.GapStyle.NOTHING : this.style.beforeSemicolon;
        FormattingStyle.GapStyle afterSemicolon = omitLineBreak ? FormattingStyle.GapStyle.NOTHING : this.style.afterSemicolon;
        return this.writeDelimiter(";", beforeSemicolon, afterSemicolon, nextLineIndentation, state);
    }

    private State writeDot(State state, boolean omitSpaceBeforeDot) {
        FormattingStyle.GapStyle beforeDot = omitSpaceBeforeDot ? FormattingStyle.GapStyle.NOTHING : this.style.beforeDot;
        return this.writeDelimiter(".", beforeDot, this.style.afterDot, "", state);
    }

    private State writeOpeningSquareBracket(State state) {
        FormattingStyle.GapStyle beforeBracket = state.indentationLevel > 0 ? this.style.beforeOpeningSquareBracket : FormattingStyle.GapStyle.NOTHING;
        return this.writeDelimiter("[", beforeBracket, this.style.afterOpeningSquareBracket, this.indent(state.indentationLevel), state);
    }

    private State writeClosingSquareBracket(State state) {
        return this.writeDelimiter("]", this.style.beforeClosingSquareBracket, this.style.afterClosingSquareBracket, this.indent(state.indentationLevel), state);
    }

    private boolean isList(RDFNode node, State state) {
        return node.equals(RDF.nil) || node.isAnon() && state.model.contains(node.asResource(), RDF.rest, (RDFNode)null);
    }

    private State writeResource(Resource resource, State state) {
        if (this.isList((RDFNode)resource, state)) {
            return this.writeList(resource, state);
        }
        if (resource.isURIResource()) {
            return this.writeUriResource(resource, state);
        }
        return this.writeAnonymousResource(resource, state);
    }

    private State writeList(Resource resource, State state) {
        FormattingStyle.GapStyle afterOpeningParenthesis = this.style.wrapListItems == FormattingStyle.WrappingStyle.ALWAYS ? FormattingStyle.GapStyle.NOTHING : this.style.afterOpeningParenthesis;
        State opened = this.writeDelimiter("(", this.style.beforeOpeningParenthesis, afterOpeningParenthesis, this.continuationIndent(state.indentationLevel), state);
        List elementList = ((RDFList)resource.as(RDFList.class)).asJavaList();
        int index = 0;
        State currentState = opened;
        for (RDFNode element : elementList) {
            boolean firstElement = index == 0;
            currentState = this.writeListElement(element, firstElement, currentState);
            ++index;
        }
        State finalLineBreakWritten = this.style.wrapListItems == FormattingStyle.WrappingStyle.ALWAYS ? currentState.newLine().write(this.indent(currentState.indentationLevel)) : currentState;
        return this.writeDelimiter(")", this.style.beforeClosingParenthesis, this.style.afterClosingParenthesis, this.continuationIndent(state.indentationLevel), finalLineBreakWritten);
    }

    private State writeListElement(RDFNode element, boolean firstElement, State state) {
        return switch (this.style.wrapListItems) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.WrappingStyle.NEVER -> {
                State spaceWritten = firstElement ? state : state.write(" ");
                yield this.writeRdfNode(element, spaceWritten);
            }
            case FormattingStyle.WrappingStyle.ALWAYS -> this.writeRdfNode(element, state.newLine().write(this.continuationIndent(state.indentationLevel)));
            case FormattingStyle.WrappingStyle.FOR_LONG_LINES -> {
                boolean wouldElementExceedLineLength;
                int alignmentAfterElementIsWritten = this.writeRdfNode((RDFNode)element, (State)state.withOutputStream((OutputStream)OutputStream.nullOutputStream())).alignment;
                boolean v1 = wouldElementExceedLineLength = alignmentAfterElementIsWritten + 1 > this.style.maxLineLength;
                yield this.writeRdfNode(element, wouldElementExceedLineLength ? state.newLine().write(this.continuationIndent(state.indentationLevel)) : (firstElement || state.getLastCharacter().equals(" ") ? state : state.write(" ")));
            }
        };
    }

    private State writeAnonymousResource(Resource resource, State state) {
        if (state.identifiedAnonymousResources.containsKey(resource)) {
            return state.write("_:" + state.identifiedAnonymousResources.getOrDefault(resource, ""));
        }
        if (!state.model.contains(resource, null, (RDFNode)null)) {
            return state.write(" []");
        }
        if (state.visitedResources.contains(resource)) {
            return state;
        }
        State afterOpeningSquareBracket = this.writeOpeningSquareBracket(state);
        State afterContent = this.writeSubject(resource, afterOpeningSquareBracket);
        return this.writeClosingSquareBracket(afterContent).withVisitedResource(resource);
    }

    private String uriResource(Resource resource, State state) {
        String uri = resource.getURI();
        String uriWithoutEmptyBase = uri.startsWith(this.style.emptyRdfBase) ? uri.substring(this.style.emptyRdfBase.length()) : uri;
        String shortForm = state.prefixMapping.shortForm(uriWithoutEmptyBase);
        if (shortForm.equals(uriWithoutEmptyBase)) {
            return "<" + uriWithoutEmptyBase + ">";
        }
        NodeFormatterTTL formatter = new NodeFormatterTTL("", (PrefixMap)new CustomPrefixMap(state.prefixMapping));
        NodeFormatterSink sink = new NodeFormatterSink();
        try {
            formatter.formatURI((AWriter)sink, uri);
        }
        catch (IRIException exception) {
            return "<" + uri + ">";
        }
        return sink.buffer.toString();
    }

    private State writeUriResource(Resource resource, State state) {
        return state.write(this.uriResource(resource, state));
    }

    private State writeLiteral(Literal literal, State state) {
        String datatypeUri = literal.getDatatypeURI();
        if (datatypeUri.equals(XSD.xdouble.getURI())) {
            if (this.style.enableDoubleFormatting) {
                return state.write(this.style.doubleFormat.format(literal.getDouble()));
            }
            if (XSD_DOUBLE_UNQUOTED_REGEX.matcher(literal.getLexicalForm()).matches()) {
                return state.write(literal.getLexicalForm());
            }
        }
        if (datatypeUri.equals(XSD.xboolean.getURI())) {
            return state.write(literal.getBoolean() ? "true" : "false");
        }
        if (datatypeUri.equals(XSD.xstring.getURI())) {
            return state.write(this.quoteAndEscape((RDFNode)literal));
        }
        if (datatypeUri.equals(XSD.decimal.getURI()) && XSD_DECIMAL_UNQUOTED_REGEX.matcher(literal.getLexicalForm()).matches()) {
            return state.write(literal.getLexicalForm());
        }
        if (datatypeUri.equals(XSD.integer.getURI())) {
            return state.write(literal.getLexicalForm());
        }
        if (datatypeUri.equals(RDF.langString.getURI())) {
            return state.write(this.quoteAndEscape((RDFNode)literal) + "@" + literal.getLanguage());
        }
        Resource typeResource = ResourceFactory.createResource((String)datatypeUri);
        State literalWritten = state.write(this.quoteAndEscape((RDFNode)literal) + "^^");
        return this.writeUriResource(typeResource, literalWritten);
    }

    private String quoteAndEscape(RDFNode node) {
        String value = node.asNode().getLiteralLexicalForm();
        String quote = switch (this.style.quoteStyle) {
            default -> throw new IncompatibleClassChangeError();
            case FormattingStyle.QuoteStyle.ALWAYS_SINGE_QUOTES -> "\"";
            case FormattingStyle.QuoteStyle.ALWAYS_TRIPLE_QUOTES -> "\"\"\"";
            case FormattingStyle.QuoteStyle.TRIPLE_QUOTES_FOR_MULTILINE -> value.contains("\n") ? "\"\"\"" : "\"";
        };
        Map<String, String> characterReplacements = Map.of("\t", "\\\\t", "\b", "\\\\b", "\r", "\\\\r", "\f", "\\\\f", "\n", quote.equals("\"") ? "\\\\n" : "\n", "\"", quote.equals("\"") ? "\\\\\"" : "\"", "\\", "\\\\\\\\");
        String escapedValue = STRING_ESCAPE_SEQUENCES.matcher(value).replaceAll(match -> characterReplacements.getOrDefault(match.group(), match.group()));
        String result = quote.equals("\"\"\"") && escapedValue.endsWith("\"") ? escapedValue.substring(0, escapedValue.length() - 1) + "\\\"" : escapedValue;
        return quote + result + quote;
    }

    private State writeRdfNode(RDFNode node, State state) {
        if (node.isResource()) {
            return this.writeResource(node.asResource(), state);
        }
        if (node.isLiteral()) {
            return this.writeLiteral(node.asLiteral(), state);
        }
        return state;
    }

    private State writeProperty(Property property, State state) {
        if (property.getURI().equals(RDF.type.getURI()) && this.style.useAForRdfType) {
            return state.write("a");
        }
        return this.writeUriResource((Resource)property, state);
    }

    private State writeSubject(Resource resource, State state) {
        if (state.visitedResources.contains(resource)) {
            return state;
        }
        boolean isIdentifiedAnon = state.identifiedAnonymousResources.containsKey(resource);
        boolean subjectsNeedsIdentation = !resource.isAnon() || isIdentifiedAnon;
        State indentedSubject = subjectsNeedsIdentation ? state.write(this.indent(state.indentationLevel)) : state;
        State stateWithSubject = resource.isURIResource() || isIdentifiedAnon ? this.writeResource(resource, indentedSubject).withVisitedResource(resource) : indentedSubject.withVisitedResource(resource);
        State gapAfterSubject = this.style.firstPredicateInNewLine || resource.isAnon() && !isIdentifiedAnon ? stateWithSubject : stateWithSubject.write(" ");
        int predicateAlignment = this.style.firstPredicateInNewLine ? this.style.indentSize : gapAfterSubject.alignment;
        Set properties = resource.listProperties().mapWith(Statement::getPredicate).toSet();
        int maxPropertyWidth = properties.stream().map(property -> this.uriResource((Resource)property, state)).map(String::length).max(Integer::compareTo).orElse(0);
        int index = 0;
        State currentState = gapAfterSubject.addIndentationLevel();
        for (Property property2 : properties.stream().sorted(state.predicateOrder).toList()) {
            boolean firstProperty = index == 0;
            boolean lastProperty = index == properties.size() - 1;
            int propertyWidth = this.uriResource((Resource)property2, currentState).length();
            String gapAfterPredicate = this.style.alignObjects ? " ".repeat(maxPropertyWidth - propertyWidth + 1) : " ";
            currentState = this.writeProperty(resource, property2, firstProperty, lastProperty, predicateAlignment, gapAfterPredicate, currentState);
            ++index;
        }
        return currentState;
    }

    private State writeProperty(Resource subject, Property predicate, boolean firstProperty, boolean lastProperty, int alignment, String gapAfterPredicate, State state) {
        Set objects = subject.listProperties(predicate).mapWith(Statement::getObject).toSet();
        boolean useComma = this.style.useCommaByDefault && !this.style.noCommaForPredicate.contains(predicate) || !this.style.useCommaByDefault && this.style.commaForPredicate.contains(predicate);
        State wrappedPredicate = firstProperty && this.style.firstPredicateInNewLine && !subject.isAnon() ? state.newLine() : state;
        boolean isNamedAnon = state.identifiedAnonymousResources.containsKey(subject);
        boolean inBrackets = subject.isAnon() && !isNamedAnon;
        boolean shouldIndentFirstPropertyByLevel = firstProperty && (this.style.firstPredicateInNewLine && !inBrackets || inBrackets && state.indentationLevel <= 1);
        boolean shouldIndentOtherPropertyByLevel = !firstProperty && (inBrackets || isNamedAnon);
        State indentedPredicateByLevel = shouldIndentFirstPropertyByLevel || shouldIndentOtherPropertyByLevel ? wrappedPredicate.write(this.indent(state.indentationLevel)) : wrappedPredicate;
        boolean shouldIndentFirstPropertyOnce = firstProperty && inBrackets && state.indentationLevel > 1;
        State indentedPredicate = shouldIndentFirstPropertyOnce ? indentedPredicateByLevel.write(this.indent(1)) : indentedPredicateByLevel;
        State predicateAlignment = !firstProperty && this.style.alignPredicates && !subject.isAnon() ? indentedPredicate.write(" ".repeat(alignment)) : indentedPredicate;
        State predicateWrittenOnce = useComma ? this.writeProperty(predicate, predicateAlignment).write(gapAfterPredicate) : predicateAlignment;
        int index = 0;
        State currentState = predicateWrittenOnce;
        for (RDFNode object : objects.stream().sorted(this.objectOrder.thenComparing(state.getRDFNodeComparatorFactory().comparator())).toList()) {
            boolean omitSpaceBeforeDelimiter;
            boolean lastObject = index == objects.size() - 1;
            State predicateWritten = useComma ? currentState : this.writeProperty(predicate, currentState);
            boolean isAnonWithBrackets = object.isAnon() && !predicateWritten.identifiedAnonymousResources.containsKey(object.asResource());
            boolean isList = this.isList(object, predicateWritten);
            State spaceWritten = !isAnonWithBrackets && !isList && !useComma ? predicateWritten.write(gapAfterPredicate) : predicateWritten;
            State objectWritten = this.writeRdfNode(object, spaceWritten);
            if (useComma && !lastObject) {
                currentState = this.writeComma(objectWritten);
                ++index;
                continue;
            }
            boolean listWritten = isList && this.style.afterClosingParenthesis == FormattingStyle.GapStyle.NOTHING;
            boolean bl = omitSpaceBeforeDelimiter = object.isResource() && object.isAnon() && !listWritten && !currentState.identifiedAnonymousResources.containsKey(object.asResource());
            if (lastProperty && lastObject && objectWritten.indentationLevel == 1 && !inBrackets) {
                currentState = this.writeDot(objectWritten, omitSpaceBeforeDelimiter).newLine();
                ++index;
                continue;
            }
            boolean doAlign = this.style.alignPredicates || subject.isAnon();
            boolean moreIdenticalPredicatesRemaining = subject.listProperties(predicate).toList().size() > 1 && !lastObject;
            boolean isAnonOrLastObject = (subject.isAnon() || lastObject) && !moreIdenticalPredicatesRemaining;
            String nextLineIndentation = doAlign && isAnonOrLastObject ? "" : this.indent(objectWritten.indentationLevel);
            State semicolonWritten = this.writeSemicolon(objectWritten, lastProperty && lastObject, omitSpaceBeforeDelimiter, nextLineIndentation);
            currentState = subject.isAnon() && lastProperty && !moreIdenticalPredicatesRemaining ? semicolonWritten.removeIndentationLevel() : semicolonWritten;
            ++index;
        }
        return currentState;
    }

    private final class State {
        private final OutputStream outputStream;
        private final Model model;
        private final Set<Resource> visitedResources;
        private final Map<Resource, String> identifiedAnonymousResources;
        private final Comparator<Property> predicateOrder;
        private final PrefixMapping prefixMapping;
        private final RDFNodeComparatorFactory RDFNodeComparatorFactory;
        private final BlankNodeMetadata blankNodeMetadata;
        private final int indentationLevel;
        private final int alignment;
        private final String lastCharacter;

        public State(OutputStream outputStream, Model model, Comparator<Property> predicateOrder, PrefixMapping prefixMapping, RDFNodeComparatorFactory RDFNodeComparatorFactory2, BlankNodeMetadata blankNodeMetadata) {
            this(outputStream, model, Set.of(), Map.of(), predicateOrder, prefixMapping, RDFNodeComparatorFactory2, blankNodeMetadata, 0, 0, "");
        }

        public State withIdentifiedAnonymousResource(Resource anonymousResource, String id) {
            HashMap<Resource, String> newMap = new HashMap<Resource, String>(this.identifiedAnonymousResources);
            newMap.put(anonymousResource, id);
            return this.withIdentifiedAnonymousResources(newMap);
        }

        public State withVisitedResource(Resource visitedResource) {
            HashSet<Resource> newSet = new HashSet<Resource>(this.visitedResources);
            newSet.add(visitedResource);
            return this.withVisitedResources(newSet);
        }

        public State addIndentationLevel() {
            return this.withIndentationLevel(this.indentationLevel + 1);
        }

        public State removeIndentationLevel() {
            return this.withIndentationLevel(this.indentationLevel - 1);
        }

        public State newLine() {
            return this.write(TurtleFormatter.this.endOfLine).withAlignment(0);
        }

        public State write(String content) {
            String end = content.length() > 0 ? content.substring(content.length() - 1) : "";
            try {
                this.outputStream.write(content.getBytes(TurtleFormatter.this.encoding));
            }
            catch (IOException e) {
                LOG.error(TurtleFormatter.OUTPUT_ERROR_MESSAGE, (Throwable)e);
            }
            return this.withLastCharacter(end).withAlignment(this.alignment + content.length());
        }

        @Generated
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Generated
        public Model getModel() {
            return this.model;
        }

        @Generated
        public Set<Resource> getVisitedResources() {
            return this.visitedResources;
        }

        @Generated
        public Map<Resource, String> getIdentifiedAnonymousResources() {
            return this.identifiedAnonymousResources;
        }

        @Generated
        public Comparator<Property> getPredicateOrder() {
            return this.predicateOrder;
        }

        @Generated
        public PrefixMapping getPrefixMapping() {
            return this.prefixMapping;
        }

        @Generated
        public RDFNodeComparatorFactory getRDFNodeComparatorFactory() {
            return this.RDFNodeComparatorFactory;
        }

        @Generated
        public BlankNodeMetadata getBlankNodeMetadata() {
            return this.blankNodeMetadata;
        }

        @Generated
        public int getIndentationLevel() {
            return this.indentationLevel;
        }

        @Generated
        public int getAlignment() {
            return this.alignment;
        }

        @Generated
        public String getLastCharacter() {
            return this.lastCharacter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            if (this.getIndentationLevel() != other.getIndentationLevel()) {
                return false;
            }
            if (this.getAlignment() != other.getAlignment()) {
                return false;
            }
            OutputStream this$outputStream = this.getOutputStream();
            OutputStream other$outputStream = other.getOutputStream();
            if (this$outputStream == null ? other$outputStream != null : !this$outputStream.equals(other$outputStream)) {
                return false;
            }
            Model this$model = this.getModel();
            Model other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            Set<Resource> this$visitedResources = this.getVisitedResources();
            Set<Resource> other$visitedResources = other.getVisitedResources();
            if (this$visitedResources == null ? other$visitedResources != null : !((Object)this$visitedResources).equals(other$visitedResources)) {
                return false;
            }
            Map<Resource, String> this$identifiedAnonymousResources = this.getIdentifiedAnonymousResources();
            Map<Resource, String> other$identifiedAnonymousResources = other.getIdentifiedAnonymousResources();
            if (this$identifiedAnonymousResources == null ? other$identifiedAnonymousResources != null : !((Object)this$identifiedAnonymousResources).equals(other$identifiedAnonymousResources)) {
                return false;
            }
            Comparator<Property> this$predicateOrder = this.getPredicateOrder();
            Comparator<Property> other$predicateOrder = other.getPredicateOrder();
            if (this$predicateOrder == null ? other$predicateOrder != null : !((Object)this$predicateOrder).equals(other$predicateOrder)) {
                return false;
            }
            PrefixMapping this$prefixMapping = this.getPrefixMapping();
            PrefixMapping other$prefixMapping = other.getPrefixMapping();
            if (this$prefixMapping == null ? other$prefixMapping != null : !this$prefixMapping.equals(other$prefixMapping)) {
                return false;
            }
            RDFNodeComparatorFactory this$RDFNodeComparatorFactory = this.getRDFNodeComparatorFactory();
            RDFNodeComparatorFactory other$RDFNodeComparatorFactory = other.getRDFNodeComparatorFactory();
            if (this$RDFNodeComparatorFactory == null ? other$RDFNodeComparatorFactory != null : !this$RDFNodeComparatorFactory.equals(other$RDFNodeComparatorFactory)) {
                return false;
            }
            BlankNodeMetadata this$blankNodeMetadata = this.getBlankNodeMetadata();
            BlankNodeMetadata other$blankNodeMetadata = other.getBlankNodeMetadata();
            if (this$blankNodeMetadata == null ? other$blankNodeMetadata != null : !this$blankNodeMetadata.equals(other$blankNodeMetadata)) {
                return false;
            }
            String this$lastCharacter = this.getLastCharacter();
            String other$lastCharacter = other.getLastCharacter();
            return !(this$lastCharacter == null ? other$lastCharacter != null : !this$lastCharacter.equals(other$lastCharacter));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndentationLevel();
            result = result * 59 + this.getAlignment();
            OutputStream $outputStream = this.getOutputStream();
            result = result * 59 + ($outputStream == null ? 43 : $outputStream.hashCode());
            Model $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            Set<Resource> $visitedResources = this.getVisitedResources();
            result = result * 59 + ($visitedResources == null ? 43 : ((Object)$visitedResources).hashCode());
            Map<Resource, String> $identifiedAnonymousResources = this.getIdentifiedAnonymousResources();
            result = result * 59 + ($identifiedAnonymousResources == null ? 43 : ((Object)$identifiedAnonymousResources).hashCode());
            Comparator<Property> $predicateOrder = this.getPredicateOrder();
            result = result * 59 + ($predicateOrder == null ? 43 : $predicateOrder.hashCode());
            PrefixMapping $prefixMapping = this.getPrefixMapping();
            result = result * 59 + ($prefixMapping == null ? 43 : $prefixMapping.hashCode());
            RDFNodeComparatorFactory $RDFNodeComparatorFactory = this.getRDFNodeComparatorFactory();
            result = result * 59 + ($RDFNodeComparatorFactory == null ? 43 : $RDFNodeComparatorFactory.hashCode());
            BlankNodeMetadata $blankNodeMetadata = this.getBlankNodeMetadata();
            result = result * 59 + ($blankNodeMetadata == null ? 43 : $blankNodeMetadata.hashCode());
            String $lastCharacter = this.getLastCharacter();
            result = result * 59 + ($lastCharacter == null ? 43 : $lastCharacter.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TurtleFormatter.State(outputStream=" + this.getOutputStream() + ", model=" + this.getModel() + ", visitedResources=" + this.getVisitedResources() + ", identifiedAnonymousResources=" + this.getIdentifiedAnonymousResources() + ", predicateOrder=" + this.getPredicateOrder() + ", prefixMapping=" + this.getPrefixMapping() + ", RDFNodeComparatorFactory=" + this.getRDFNodeComparatorFactory() + ", blankNodeMetadata=" + this.getBlankNodeMetadata() + ", indentationLevel=" + this.getIndentationLevel() + ", alignment=" + this.getAlignment() + ", lastCharacter=" + this.getLastCharacter() + ")";
        }

        @Generated
        public State withOutputStream(OutputStream outputStream) {
            return this.outputStream == outputStream ? this : new State(outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.RDFNodeComparatorFactory, this.blankNodeMetadata, this.indentationLevel, this.alignment, this.lastCharacter);
        }

        @Generated
        public State withModel(Model model) {
            return this.model == model ? this : new State(this.outputStream, model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.RDFNodeComparatorFactory, this.blankNodeMetadata, this.indentationLevel, this.alignment, this.lastCharacter);
        }

        @Generated
        public State withVisitedResources(Set<Resource> visitedResources) {
            return this.visitedResources == visitedResources ? this : new State(this.outputStream, this.model, visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.RDFNodeComparatorFactory, this.blankNodeMetadata, this.indentationLevel, this.alignment, this.lastCharacter);
        }

        @Generated
        public State withIdentifiedAnonymousResources(Map<Resource, String> identifiedAnonymousResources) {
            return this.identifiedAnonymousResources == identifiedAnonymousResources ? this : new State(this.outputStream, this.model, this.visitedResources, identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.RDFNodeComparatorFactory, this.blankNodeMetadata, this.indentationLevel, this.alignment, this.lastCharacter);
        }

        @Generated
        public State withPredicateOrder(Comparator<Property> predicateOrder) {
            return this.predicateOrder == predicateOrder ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, predicateOrder, this.prefixMapping, this.RDFNodeComparatorFactory, this.blankNodeMetadata, this.indentationLevel, this.alignment, this.lastCharacter);
        }

        @Generated
        public State withPrefixMapping(PrefixMapping prefixMapping) {
            return this.prefixMapping == prefixMapping ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, prefixMapping, this.RDFNodeComparatorFactory, this.blankNodeMetadata, this.indentationLevel, this.alignment, this.lastCharacter);
        }

        @Generated
        public State withRDFNodeComparatorFactory(RDFNodeComparatorFactory RDFNodeComparatorFactory2) {
            return this.RDFNodeComparatorFactory == RDFNodeComparatorFactory2 ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, RDFNodeComparatorFactory2, this.blankNodeMetadata, this.indentationLevel, this.alignment, this.lastCharacter);
        }

        @Generated
        public State withBlankNodeMetadata(BlankNodeMetadata blankNodeMetadata) {
            return this.blankNodeMetadata == blankNodeMetadata ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.RDFNodeComparatorFactory, blankNodeMetadata, this.indentationLevel, this.alignment, this.lastCharacter);
        }

        @Generated
        public State withIndentationLevel(int indentationLevel) {
            return this.indentationLevel == indentationLevel ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.RDFNodeComparatorFactory, this.blankNodeMetadata, indentationLevel, this.alignment, this.lastCharacter);
        }

        @Generated
        public State withAlignment(int alignment) {
            return this.alignment == alignment ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.RDFNodeComparatorFactory, this.blankNodeMetadata, this.indentationLevel, alignment, this.lastCharacter);
        }

        @Generated
        public State withLastCharacter(String lastCharacter) {
            return this.lastCharacter == lastCharacter ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.RDFNodeComparatorFactory, this.blankNodeMetadata, this.indentationLevel, this.alignment, lastCharacter);
        }

        @Generated
        public State(OutputStream outputStream, Model model, Set<Resource> visitedResources, Map<Resource, String> identifiedAnonymousResources, Comparator<Property> predicateOrder, PrefixMapping prefixMapping, RDFNodeComparatorFactory RDFNodeComparatorFactory2, BlankNodeMetadata blankNodeMetadata, int indentationLevel, int alignment, String lastCharacter) {
            this.outputStream = outputStream;
            this.model = model;
            this.visitedResources = visitedResources;
            this.identifiedAnonymousResources = identifiedAnonymousResources;
            this.predicateOrder = predicateOrder;
            this.prefixMapping = prefixMapping;
            this.RDFNodeComparatorFactory = RDFNodeComparatorFactory2;
            this.blankNodeMetadata = blankNodeMetadata;
            this.indentationLevel = indentationLevel;
            this.alignment = alignment;
            this.lastCharacter = lastCharacter;
        }
    }

    static class CustomPrefixMap
    extends PrefixMapBase
    implements PrefixMap {
        private final PrefixMapping mapping;

        public CustomPrefixMap(PrefixMapping mapping) {
            this.mapping = mapping;
        }

        public String get(String prefix) {
            return this.mapping.getNsPrefixURI(prefix);
        }

        public Map<String, String> getMapping() {
            return this.mapping.getNsPrefixMap();
        }

        public void add(String prefix, String iriString) {
        }

        public void delete(String prefix) {
        }

        public void clear() {
        }

        public boolean containsPrefix(String prefix) {
            return this.mapping.getNsPrefixMap().containsKey(prefix);
        }

        public boolean isEmpty() {
            return this.mapping.getNsPrefixMap().isEmpty();
        }

        public int size() {
            return this.mapping.getNsPrefixMap().size();
        }

        public Pair<String, String> abbrev(String uriStr) {
            return PrefixLib.abbrev((PrefixMap)this, (String)uriStr);
        }
    }

    class NodeFormatterSink
    implements AWriter {
        StringBuffer buffer = new StringBuffer();

        NodeFormatterSink() {
        }

        public void write(char ch) {
            this.buffer.append(ch);
        }

        public void write(char[] cbuf) {
            this.buffer.append(cbuf);
        }

        public void write(String string) {
            this.buffer.append(string);
        }

        public void print(char ch) {
            this.write(ch);
        }

        public void print(char[] cbuf) {
            this.write(cbuf);
        }

        public void print(String string) {
            this.write(string);
        }

        public void printf(String fmt, Object ... arg) {
            this.write(String.format(fmt, arg));
        }

        public void println(String object) {
            this.write(object + TurtleFormatter.this.endOfLine);
        }

        public void println() {
            this.write(TurtleFormatter.this.endOfLine);
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

