/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;

public class IoUtil {
    public static String contentFromFile(String fileName) {
        return IoUtil.convertStreamToString(IoUtil.class.getClassLoader().getResourceAsStream(fileName));
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static void writeToFile(String content, String outputFilePath) {
        OutputStream fileOutput = null;
        try {
            fileOutput = new FileOutputStream(new File(outputFilePath));
            ((FileOutputStream)fileOutput).write(content.getBytes("UTF-8"));
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        finally {
            if (fileOutput != null) {
                try {
                    fileOutput.flush();
                    ((FileOutputStream)fileOutput).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

