/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler.netty;

import de.androbit.nibbler.converter.ContentConverters;
import de.androbit.nibbler.converter.TypedInput;
import de.androbit.nibbler.http.Header;
import de.androbit.nibbler.http.MediaType;
import de.androbit.nibbler.http.Params;
import de.androbit.nibbler.http.RequestPath;
import de.androbit.nibbler.http.RestHttpMethod;
import de.androbit.nibbler.http.RestRequest;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class NettyRequestWrapper
implements RestRequest {
    private final HttpServerRequest<ByteBuf> request;
    private final ContentConverters converters;
    private final ByteBuf content;
    private Map<String, String> pathParams;

    public NettyRequestWrapper(HttpServerRequest<ByteBuf> request, ByteBuf content, ContentConverters converters) {
        this.request = request;
        this.converters = converters;
        this.content = content;
    }

    public RestHttpMethod method() {
        return RestHttpMethod.valueOf((String)this.request.getHttpMethod().name());
    }

    public RequestPath path() {
        return new RequestPath(this.request.getPath());
    }

    public Params pathParams() {
        HashMap paramsWithListValues = new HashMap();
        this.pathParams.forEach((key, value) -> paramsWithListValues.put(key, Arrays.asList(value)));
        return new Params(paramsWithListValues);
    }

    public Params queryParams() {
        return new Params(this.request.getQueryParameters());
    }

    public String header(String name) {
        return this.request.getHeaders().get(name);
    }

    public TypedInput body() {
        return new TypedInput(this.getContentStream(), this.getContentType());
    }

    public <T> T bodyAs(Class<T> clazz) {
        return this.convertBodyContent(this.getContentType(), clazz);
    }

    public <T> T convertBodyContent(MediaType contentType, Class<T> clazz) {
        return (T)this.converters.getConverter(contentType).orElse(this.converters.getDefaultConverter()).fromBody(new TypedInput(this.getContentStream(), contentType), clazz);
    }

    InputStream getContentStream() {
        byte[] bytes = new byte[this.content.readableBytes()];
        int readerIndex = this.content.readerIndex();
        this.content.getBytes(readerIndex, bytes);
        return new ByteArrayInputStream(bytes);
    }

    MediaType getContentType() {
        String header = this.header(Header.ContentType.name());
        return header != null ? MediaType.valueOf((String)header) : MediaType.APPLICATION_OCTECT_STREAM;
    }

    public NettyRequestWrapper withPathParams(Map<String, String> pathParams) {
        this.pathParams = pathParams;
        return this;
    }
}

