/*
 * Decompiled with CFR 0.152.
 */
package de.androbit.nibbler.netty;

import de.androbit.nibbler.RestHttpServer;
import de.androbit.nibbler.RestHttpServerConfiguration;
import de.androbit.nibbler.RestService;
import de.androbit.nibbler.converter.ContentConverters;
import de.androbit.nibbler.http.RequestHandlerMatcher;
import de.androbit.nibbler.netty.NettyServiceRequestHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpServer
implements RestHttpServer {
    private HttpServer<ByteBuf, ByteBuf> nettyServer;
    Logger log = LoggerFactory.getLogger(NettyHttpServer.class);

    public void start(RestHttpServerConfiguration configuration) {
        this.nettyServer = this.createServer(configuration).start();
    }

    private HttpServer<ByteBuf, ByteBuf> createServer(RestHttpServerConfiguration configuration) {
        ServerBootstrap serverBootstrap = this.createServerBootstrap(configuration.getInterface(), configuration.getPort());
        HttpServerBuilder httpServerBuilder = (HttpServerBuilder)((HttpServerBuilder)new HttpServerBuilder(serverBootstrap, configuration.getPort(), (RequestHandler)this.createServiceRequestHandler(configuration.getRestServices(), configuration.getConverters())).pipelineConfigurator(PipelineConfigurators.httpServerConfigurator())).withRequestProcessingThreads(configuration.getRequestProcessingThreads()).enableWireLogging(LogLevel.DEBUG);
        String message = "starting http server on port %s at interface %s, with %s processing threads ...";
        this.log.info(String.format(message, configuration.getPort(), configuration.getInterface(), configuration.getRequestProcessingThreads()));
        this.logServices(configuration.getRestServices());
        return httpServerBuilder.build();
    }

    public void startAndWait(RestHttpServerConfiguration configuration) {
        this.nettyServer = this.createServer(configuration);
        this.nettyServer.startAndWait();
    }

    private void logServices(List<RestService> restServices) {
        restServices.forEach(service -> this.log.info(String.format("registered service: %s", service)));
    }

    public synchronized void stop() {
        try {
            this.nettyServer.shutdown();
            this.nettyServer.waitTillShutdown();
        }
        catch (InterruptedException e) {
            throw new RuntimeException();
        }
    }

    private ServerBootstrap createServerBootstrap(String anInterface, int port) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        try {
            serverBootstrap.localAddress(InetAddress.getByName(anInterface), port);
            return serverBootstrap;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException();
        }
    }

    NettyServiceRequestHandler createServiceRequestHandler(List<RestService> restServices, ContentConverters converters) {
        ArrayList pathDefinitions = new ArrayList();
        for (RestService restService : restServices) {
            pathDefinitions.addAll(restService.getPaths());
        }
        return new NettyServiceRequestHandler(new RequestHandlerMatcher(pathDefinitions), converters);
    }
}

