/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.builder;

import brainslug.flow.expression.Expression;
import brainslug.flow.node.task.CallDefinition;
import brainslug.flow.node.task.InvokeDefinition;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Stack;

public class ServiceCallInvocationSupport {
    Stack<ProxyStackEntry> proxyStack = new Stack();

    public void argument(Expression expression) {
        this.proxyStack.push(new ParameterEntry<Expression>(expression));
    }

    public CallDefinition createCallDefinitionFromCurrentStack() {
        if (this.proxyStack.empty()) {
            throw new IllegalStateException("no service invocation given. you must define one first...");
        }
        ProxyStackEntry lastInvocation = this.proxyStack.pop();
        if (lastInvocation instanceof ServiceInvocationEntry) {
            this.proxyStack.clear();
            return (ServiceInvocationEntry)lastInvocation;
        }
        throw new IllegalStateException("you must define a valid service invocation.");
    }

    public boolean empty() {
        return this.proxyStack.empty();
    }

    public <T> T createServiceProxy(final Class<T> clazz) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] arguments) throws Throwable {
                if (method.getDeclaringClass().getName().equals(Object.class.getName())) {
                    return null;
                }
                ServiceInvocationEntry invocation = new ServiceInvocationEntry(clazz);
                invocation.method(method);
                ServiceCallInvocationSupport.this.proxyStack.add(ServiceCallInvocationSupport.this.withArgumentsFromStack(invocation));
                return null;
            }
        };
        return (T)this.createProxyInstance(clazz, handler);
    }

    private ServiceInvocationEntry withArgumentsFromStack(ServiceInvocationEntry invocation) {
        for (int paramIndex = 0; paramIndex < invocation.getMethod().getParameterTypes().length; ++paramIndex) {
            invocation.arg(this.proxyStack.pop());
        }
        return invocation;
    }

    protected <T> Object createProxyInstance(Class<T> clazz, InvocationHandler handler) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, handler);
    }

    public class ParameterEntry<T>
    implements ProxyStackEntry {
        T value;

        ParameterEntry(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class ServiceInvocationEntry
    extends InvokeDefinition
    implements ProxyStackEntry {
        public ServiceInvocationEntry(Class<?> serviceClass) {
            super(serviceClass);
        }
    }

    public static interface ProxyStackEntry {
    }
}

