/*
 * Decompiled with CFR 0.152.
 */
package brainslug.util;

import java.util.NoSuchElementException;

public class Option<T> {
    private final T value;

    private Option(T value) {
        this.value = value;
    }

    public static <T> Option<T> empty() {
        return new Option<Object>(null);
    }

    public static <T> Option<T> of(T value) {
        return new Option<T>(value);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T get() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException();
    }

    public T orElse(T other) {
        if (this.isPresent()) {
            return this.value;
        }
        return other;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        return !(this.value != null ? !this.value.equals(option.value) : option.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "Option{value=" + this.value + '}';
    }
}

