/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.table.toolbars;

import de.agilecoders.wicket.core.markup.html.bootstrap.navigation.BootstrapPagingNavigator;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.navigation.BootstrapNavigatorLabel;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class BootstrapNavigationToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    private static final String _PAGING_NAVIGATOR_ID = "navigator";
    private static final String _NAVIGATOR_LABEL_PANEL_ID = "navigatorLabelPanel";

    public BootstrapNavigationToolbar(DataTable<?, ?> table) {
        this(table, BootstrapPagingNavigator.Size.Default);
    }

    public BootstrapNavigationToolbar(DataTable<?, ?> table, BootstrapPagingNavigator.Size size) {
        super(table);
        WebMarkupContainer span = new WebMarkupContainer("span");
        this.add(new Component[]{span});
        span.add(new Behavior[]{AttributeModifier.replace((String)"colspan", (IModel & Serializable)() -> String.valueOf(table.getColumns().size()))});
        span.add(new Component[]{this.newPagingNavigator(_PAGING_NAVIGATOR_ID, table, size)});
        span.add(new Component[]{this.newNavigatorLabel(_NAVIGATOR_LABEL_PANEL_ID, table, size)});
    }

    protected BootstrapPagingNavigator newPagingNavigator(String navigatorId, DataTable<?, ?> table, final BootstrapPagingNavigator.Size size) {
        return new BootstrapPagingNavigator(navigatorId, (IPageable)table){

            public BootstrapPagingNavigator.Size getSize() {
                return size;
            }
        };
    }

    protected Panel newNavigatorLabel(String navigatorId, DataTable<?, ?> table, BootstrapPagingNavigator.Size size) {
        return new BootstrapNavigatorLabel(navigatorId, table, size);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setVisible(this.getTable().getPageCount() > 1L);
    }
}

