/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.fileUpload;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.util.References;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.fileUpload.DropZoneConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.fileUpload.DropZoneFileUploadJavaScriptReference;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.template.PackageTextTemplate;

public abstract class DropZoneFileUpload
extends Panel {
    private static final long serialVersionUID = 1L;
    private final DropZoneConfig config;
    private DropZoneFileUploadAjaxEventBehavior dropZoneFileUploadAjaxEventBehavior;

    public DropZoneFileUpload(String id) {
        this(id, null, new DropZoneConfig());
    }

    public DropZoneFileUpload(String id, IModel<?> model) {
        this(id, model, new DropZoneConfig());
    }

    public DropZoneFileUpload(String id, IModel<?> model, DropZoneConfig config) {
        super(id, model);
        this.config = (DropZoneConfig)((Object)Args.notNull((Object)((Object)config), (String)"config"));
        Behavior[] behaviorArray = new Behavior[1];
        this.dropZoneFileUploadAjaxEventBehavior = new DropZoneFileUploadAjaxEventBehavior();
        behaviorArray[0] = this.dropZoneFileUploadAjaxEventBehavior;
        this.add(behaviorArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderHead(IHeaderResponse response) {
        References.renderWithFilter((IBootstrapSettings)Bootstrap.getSettings(), (IHeaderResponse)response, (JavaScriptReferenceHeaderItem[])new JavaScriptReferenceHeaderItem[]{JavaScriptReferenceHeaderItem.forReference((ResourceReference)DropZoneFileUploadJavaScriptReference.instance())});
        PackageTextTemplate dropZoneTemplate = null;
        try {
            dropZoneTemplate = new PackageTextTemplate(DropZoneFileUpload.class, "js/dropzone_init.js");
            this.config.withCallbackUrl(this.dropZoneFileUploadAjaxEventBehavior.getCallbackUrl().toString());
            String jsonConfig = this.config.toJsonString();
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("config", jsonConfig);
            String js = dropZoneTemplate.asString(variables);
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)js));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dropZoneTemplate);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)dropZoneTemplate);
    }

    public final DropZoneConfig getConfig() {
        return this.config;
    }

    protected abstract void onUpload(AjaxRequestTarget var1, Map<String, List<FileItem>> var2);

    protected void onError(AjaxRequestTarget target, FileUploadException fux) {
    }

    private class DropZoneFileUploadAjaxEventBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private DropZoneFileUploadAjaxEventBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            try {
                ServletWebRequest webRequest = (ServletWebRequest)DropZoneFileUpload.this.getRequest();
                MultipartServletWebRequest multiPartRequest = webRequest.newMultipartWebRequest(Bytes.megabytes((long)DropZoneFileUpload.this.config.getMaxFileSize()), "ignored");
                multiPartRequest.parseFileParts();
                DropZoneFileUpload.this.onUpload(target, multiPartRequest.getFiles());
            }
            catch (FileUploadException fux) {
                DropZoneFileUpload.this.onError(target, fux);
            }
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.setMultipart(true);
        }
    }
}

