/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.javascript.jasny;

import de.agilecoders.wicket.javascript.jasny.JasnyJsReference;
import de.agilecoders.wicket.markup.html.bootstrap.common.AbstractConfig;
import de.agilecoders.wicket.util.JQuery;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;

public abstract class InputMaskBehavior
extends Behavior {
    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        String mask = this.getMask();
        if (!Strings.isEmpty((CharSequence)mask)) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JasnyJsReference.INSTANCE));
            InputMaskConfig config = new InputMaskConfig();
            config.withMask(mask);
            String placeholder = this.getPlaceholder();
            if (!Strings.isEmpty((CharSequence)placeholder)) {
                config.withPlaceholder(placeholder);
            }
            response.render((HeaderItem)JQuery.$((Component)component).chain("inputmask", (AbstractConfig)config).asDomReadyScript());
        }
    }

    protected abstract String getMask();

    protected String getPlaceholder() {
        return (String)InputMaskConfig.Placeholder.getDefaultValue();
    }

    private static class InputMaskConfig
    extends AbstractConfig {
        private static final AbstractConfig.IKey<String> Mask = InputMaskConfig.newKey((String)"mask", null);
        private static final AbstractConfig.IKey<String> Placeholder = InputMaskConfig.newKey((String)"withPlaceholder", (Object)"_");

        private InputMaskConfig() {
        }

        private InputMaskConfig withMask(String mask) {
            this.put(Mask, mask);
            return this;
        }

        private InputMaskConfig withPlaceholder(String placeholder) {
            this.put(Placeholder, placeholder);
            return this;
        }
    }
}

