/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.javascript;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.css.ICssCompressor;

public class YuiCssCompressor
implements ICssCompressor {
    private static final String PRESERVE_COMMENT = "___YUICSSMIN_PRESERVE_CANDIDATE_COMMENT_";
    private static final String PRESERVE_TOKEN = "___YUICSSMIN_PRESERVED_TOKEN_";
    private static final String PSEUDEO_CLASS = "___YUICSSMIN_PSEUDOCLASSCOLON___";
    private static final Pattern URL_PATTERN = Pattern.compile("url\\(\\s*([\"']?)data\\:");
    private static final Pattern STRING_PATTERN = Pattern.compile("(\"([^\\\\\"]|\\\\.|\\\\)*\")|('([^\\\\']|\\\\.|\\\\)*')");
    private static final Pattern BRACKETS_PATTERN = Pattern.compile("(^|\\})(([^\\{:])+:)+([^\\{]*\\{)");
    private static final Pattern BORDER_PATTERN = Pattern.compile("(?i)(border|border-top|border-right|border-bottom|border-right|outline|background):none(;|})");
    private static final Pattern RGB_PATTERN = Pattern.compile("rgb\\s*\\(\\s*([0-9,\\s]+)\\s*\\)");
    private static final Pattern HEX_PATTERN = Pattern.compile("(\\=\\s*?[\"']?)?#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])(:?\\}|[^0-9a-fA-F{][^{]*?\\})");
    private static final Pattern BROWSER_HACKS_PATTERN = Pattern.compile("(?i)(background-position|transform-origin|webkit-transform-origin|moz-transform-origin|o-transform-origin|ms-transform-origin):0(;|})");

    private String extractDataUrls(String css, List<String> preservedTokens) {
        int maxIndex = css.length() - 1;
        int appendIndex = 0;
        StringBuilder buffer = new StringBuilder();
        Matcher m = URL_PATTERN.matcher(css);
        while (m.find()) {
            int startIndex = m.start() + 4;
            String terminator = m.group(1);
            if (terminator.length() == 0) {
                terminator = ")";
            }
            boolean foundTerminator = false;
            int endIndex = m.end() - 1;
            while (!foundTerminator && endIndex + 1 <= maxIndex) {
                if ((endIndex = css.indexOf(terminator, endIndex + 1)) <= 0 || css.charAt(endIndex - 1) == '\\') continue;
                foundTerminator = true;
                if (")".equals(terminator)) continue;
                endIndex = css.indexOf(")", endIndex);
            }
            buffer.append(css.substring(appendIndex, m.start()));
            if (foundTerminator) {
                String token = css.substring(startIndex, endIndex);
                token = token.replaceAll("\\s+", "");
                preservedTokens.add(token);
                String preserver = "url(___YUICSSMIN_PRESERVED_TOKEN_" + (preservedTokens.size() - 1) + "___)";
                buffer.append(preserver);
                appendIndex = endIndex + 1;
                continue;
            }
            buffer.append(css.substring(m.start(), m.end()));
            appendIndex = m.end();
        }
        buffer.append(css.substring(appendIndex));
        return buffer.toString();
    }

    private String compress(String css, int linebreakPosition) {
        int i;
        int max;
        String token;
        int startIndex = 0;
        ArrayList preservedTokens = Lists.newArrayList();
        ArrayList comments = Lists.newArrayList();
        int contentLength = css.length();
        css = this.extractDataUrls(css, preservedTokens);
        StringBuffer sb = new StringBuffer(css);
        while ((startIndex = sb.indexOf("/*", startIndex)) >= 0) {
            int endIndex = sb.indexOf("*/", startIndex + 2);
            if (endIndex < 0) {
                endIndex = contentLength;
            }
            token = sb.substring(startIndex + 2, endIndex);
            comments.add(token);
            sb.replace(startIndex + 2, endIndex, PRESERVE_COMMENT + (comments.size() - 1) + "___");
            startIndex += 2;
        }
        css = sb.toString();
        sb = new StringBuffer();
        Matcher m = STRING_PATTERN.matcher(css);
        while (m.find()) {
            token = m.group();
            char quote = token.charAt(0);
            if ((token = token.substring(1, token.length() - 1)).contains(PRESERVE_COMMENT)) {
                max = comments.size();
                for (i = 0; i < max; ++i) {
                    token = token.replace(PRESERVE_COMMENT + i + "___", (CharSequence)comments.get(i));
                }
            }
            token = token.replaceAll("(?i)progid:DXImageTransform.Microsoft.Alpha\\(Opacity=", "alpha(opacity=");
            preservedTokens.add(token);
            String preserver = quote + PRESERVE_TOKEN + (preservedTokens.size() - 1) + "___" + quote;
            m.appendReplacement(sb, preserver);
        }
        m.appendTail(sb);
        css = sb.toString();
        max = comments.size();
        for (i = 0; i < max; ++i) {
            token = (String)comments.get(i);
            String placeholder = PRESERVE_COMMENT + i + "___";
            if (token.startsWith("!")) {
                preservedTokens.add(token);
                css = css.replace(placeholder, PRESERVE_TOKEN + (preservedTokens.size() - 1) + "___");
                continue;
            }
            if (token.endsWith("\\")) {
                preservedTokens.add("\\");
                css = css.replace(placeholder, PRESERVE_TOKEN + (preservedTokens.size() - 1) + "___");
                preservedTokens.add("");
                css = css.replace(PRESERVE_COMMENT + ++i + "___", PRESERVE_TOKEN + (preservedTokens.size() - 1) + "___");
                continue;
            }
            if (token.length() == 0 && (startIndex = css.indexOf(placeholder)) > 2 && css.charAt(startIndex - 3) == '>') {
                preservedTokens.add("");
                css = css.replace(placeholder, PRESERVE_TOKEN + (preservedTokens.size() - 1) + "___");
            }
            css = css.replace("/*" + placeholder + "*/", "");
        }
        css = css.replaceAll("\\s+", " ");
        sb = new StringBuffer();
        m = BRACKETS_PATTERN.matcher(css);
        while (m.find()) {
            String s = m.group();
            s = s.replaceAll(":", PSEUDEO_CLASS);
            s = s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
            m.appendReplacement(sb, s);
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("\\s+([!{};:>+\\(\\)\\],])", "$1");
        css = css.replaceAll(PSEUDEO_CLASS, ":");
        css = css.replaceAll(":first\\-(line|letter)(\\{|,)", ":first-$1 $2");
        css = css.replaceAll("\\*/ ", "*/");
        css = css.replaceAll("^(.*)(@charset \"[^\"]*\";)", "$2$1");
        css = css.replaceAll("^(\\s*@charset [^;]+;\\s*)+", "$1");
        css = css.replaceAll("\\band\\(", "and (");
        css = css.replaceAll("([!{}:;>+\\(\\[,])\\s+", "$1");
        css = css.replaceAll(";+}", "}");
        css = css.replaceAll("([\\s:])(0)(px|em|%|in|cm|mm|pc|pt|ex)", "$1$2");
        css = css.replaceAll(":0 0 0 0(;|})", ":0$1");
        css = css.replaceAll(":0 0 0(;|})", ":0$1");
        css = css.replaceAll(":0 0(;|})", ":0$1");
        sb = new StringBuffer();
        m = BROWSER_HACKS_PATTERN.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toLowerCase() + ":0 0" + m.group(2));
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("(:|\\s)0+\\.(\\d+)", "$1.$2");
        m = RGB_PATTERN.matcher(css);
        sb = new StringBuffer();
        while (m.find()) {
            String[] rgbcolors = m.group(1).split(",");
            StringBuilder hexcolor = new StringBuilder("#");
            for (i = 0; i < rgbcolors.length; ++i) {
                int val = Integer.parseInt(rgbcolors[i]);
                if (val < 16) {
                    hexcolor.append("0");
                }
                hexcolor.append(Integer.toHexString(val));
            }
            m.appendReplacement(sb, hexcolor.toString());
        }
        m.appendTail(sb);
        css = sb.toString();
        m = HEX_PATTERN.matcher(css);
        sb = new StringBuffer();
        int index = 0;
        while (m.find(index)) {
            boolean isFilter;
            sb.append(css.substring(index, m.start()));
            boolean bl = isFilter = m.group(1) != null && !"".equals(m.group(1));
            if (isFilter) {
                sb.append(m.group(1) + "#" + m.group(2) + m.group(3) + m.group(4) + m.group(5) + m.group(6) + m.group(7));
            } else if (m.group(2).equalsIgnoreCase(m.group(3)) && m.group(4).equalsIgnoreCase(m.group(5)) && m.group(6).equalsIgnoreCase(m.group(7))) {
                sb.append("#" + (m.group(3) + m.group(5) + m.group(7)).toLowerCase());
            } else {
                sb.append("#" + (m.group(2) + m.group(3) + m.group(4) + m.group(5) + m.group(6) + m.group(7)).toLowerCase());
            }
            index = m.end(7);
        }
        sb.append(css.substring(index));
        css = sb.toString();
        sb = new StringBuffer();
        m = BORDER_PATTERN.matcher(css);
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toLowerCase() + ":0" + m.group(2));
        }
        m.appendTail(sb);
        css = sb.toString();
        css = css.replaceAll("(?i)progid:DXImageTransform.Microsoft.Alpha\\(Opacity=", "alpha(opacity=");
        css = css.replaceAll("[^\\}\\{/;]+\\{\\}", "");
        if (linebreakPosition >= 0) {
            i = 0;
            int linestartpos = 0;
            StringBuilder linebreakBuilder = new StringBuilder(css);
            while (i < linebreakBuilder.length()) {
                char c;
                if ((c = linebreakBuilder.charAt(i++)) != '}' || i - linestartpos <= linebreakPosition) continue;
                linebreakBuilder.insert(i, '\n');
                linestartpos = i;
            }
            css = linebreakBuilder.toString();
        }
        css = css.replaceAll(";;+", ";");
        max = preservedTokens.size();
        for (i = 0; i < max; ++i) {
            css = css.replace(PRESERVE_TOKEN + i + "___", (CharSequence)preservedTokens.get(i));
        }
        return css.trim();
    }

    public String compress(String original) {
        return this.compress(original, 4000);
    }
}

