/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.panel;

import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BootstrapGenericPanel<T>
extends GenericPanel<T> {
    private static final String _PANEL_TITLE_ID = "panelTitle";
    private static final String _PANEL_IMAGE_ID = "panelImageTop";
    private static final String _PANEL_BODY_ID = "panelBody";
    private static final String _PANEL_FOOTER_ID = "panelFooter";
    private final IModel<String> titleModel;

    public BootstrapGenericPanel(String id) {
        this(id, null, null);
    }

    public BootstrapGenericPanel(String id, IModel<T> model, IModel<String> panelTitleModel) {
        super(id, model);
        this.titleModel = panelTitleModel;
    }

    protected void onInitialize() {
        super.onInitialize();
        Label panelTitle = this.newTitleLabel(_PANEL_TITLE_ID, this.getModel(), this.getTitleModel());
        this.add(new Component[]{panelTitle});
        Components.hideIfModelIsEmpty((Component)panelTitle);
        Component topImage = this.newTopImage(_PANEL_IMAGE_ID, this.getModel());
        this.add(new Component[]{topImage});
        Components.hideIfModelIsEmpty(topImage);
        Panel panelBody = this.newBodyPanel(_PANEL_BODY_ID, this.getModel());
        this.add(new Component[]{panelBody});
        Components.hideIfModelIsEmpty((Component)panelBody);
        Panel panelFooter = this.newFooterPanel(_PANEL_FOOTER_ID, this.getModel());
        this.add(new Component[]{panelFooter});
        Components.hideIfModelIsEmpty((Component)panelFooter);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Components.assertTag((Component)this, tag, "div");
        Attributes.addClass(tag, "card");
    }

    public IModel<String> getTitleModel() {
        return this.titleModel;
    }

    protected Label newTitleLabel(String id, IModel<T> model, IModel<String> titleModel) {
        return new Label(id, titleModel);
    }

    protected Panel newBodyPanel(String id, IModel<T> model) {
        EmptyPanel emptyPanel = new EmptyPanel(id);
        emptyPanel.setDefaultModel((IModel)new Model());
        return emptyPanel;
    }

    protected Panel newFooterPanel(String id, IModel<T> model) {
        EmptyPanel emptyPanel = new EmptyPanel(id);
        emptyPanel.setDefaultModel((IModel)new Model());
        return emptyPanel;
    }

    protected Component newTopImage(String id, IModel<T> model) {
        EmptyPanel emptyTopImage = new EmptyPanel(id);
        emptyTopImage.setDefaultModel(null);
        return emptyTopImage;
    }
}

