/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.util;

import de.agilecoders.wicket.Bootstrap;
import de.agilecoders.wicket.settings.IBootstrapSettings;
import de.agilecoders.wicket.util.Strings2;
import org.apache.wicket.Application;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.filter.FilteredHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.Strings;

public final class References {
    private References() {
        throw new UnsupportedOperationException();
    }

    public static String appendMinificationIdentifier(String referenceUrl) {
        if (!Strings.isEmpty((CharSequence)referenceUrl) && referenceUrl.contains(".") && Application.get().getResourceSettings().getUseMinifiedResources()) {
            return referenceUrl.replaceFirst("\\.(?=[^.]*$)", ".min.");
        }
        return Strings2.nullToEmpty(referenceUrl);
    }

    public static void renderWithFilter(IHeaderResponse response, ResourceReference reference) {
        References.renderWithFilter(response, JavaScriptHeaderItem.forReference((ResourceReference)reference));
    }

    public static void renderWithFilter(IHeaderResponse response, JavaScriptReferenceHeaderItem headerItem) {
        References.renderWithFilter(Bootstrap.getSettings(), response, headerItem);
    }

    public static void renderWithFilter(IBootstrapSettings settings, IHeaderResponse response, JavaScriptReferenceHeaderItem headerItem) {
        String filterName = settings.getJsResourceFilterName();
        if (Strings.isEmpty((CharSequence)filterName)) {
            response.render((HeaderItem)headerItem);
        } else {
            response.render((HeaderItem)new FilteredHeaderItem((HeaderItem)headerItem, filterName));
        }
    }
}

