/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.util;

import de.agilecoders.wicket.markup.html.bootstrap.form.IDataSource;
import de.agilecoders.wicket.util.ConfigModel;
import java.io.IOException;
import org.apache.wicket.util.string.Strings;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.type.JavaType;

public final class Json {
    private Json() {
        throw new UnsupportedOperationException();
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        SimpleModule wbModule = new SimpleModule("wicket-bootstrap", new Version(1, 0, 0, null));
        wbModule.addSerializer(ConfigModel.class, (JsonSerializer)new JsonSerializer<ConfigModel>(){

            public void serialize(ConfigModel value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeString(value.getObject());
            }
        });
        wbModule.addSerializer(IDataSource.class, (JsonSerializer)new JsonSerializer<IDataSource>(){

            public void serialize(IDataSource value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeObject((Object)Json.stringify(value.load()));
            }
        });
        mapper.registerModule((Module)wbModule);
        return mapper;
    }

    public static JsonNode toJson(Object data) {
        if (data == null) {
            return Json.newObject();
        }
        try {
            return Json.createObjectMapper().valueToTree(data);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T fromJson(JsonNode json, Class<T> clazz) {
        try {
            return (T)Json.createObjectMapper().treeToValue(json, clazz);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T fromJson(String json, JavaType type) {
        try {
            return (T)Json.createObjectMapper().readValue(Json.parse(json), type);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return Json.fromJson(Json.parse(json), clazz);
    }

    public static ObjectNode newObject() {
        return Json.createObjectMapper().createObjectNode();
    }

    public static String stringify(JsonNode json) {
        return json != null ? json.toString() : "{}";
    }

    public static String stringify(Object data) {
        return Json.stringify(Json.toJson(data));
    }

    public static boolean isValid(String json) {
        if (Strings.isEmpty((CharSequence)json)) {
            return false;
        }
        try {
            return Json.parse(json) != null;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static JsonNode parse(String jsonString) {
        if (Strings.isEmpty((CharSequence)jsonString)) {
            return Json.newObject();
        }
        try {
            return (JsonNode)Json.createObjectMapper().readValue(jsonString, JsonNode.class);
        }
        catch (Throwable e) {
            throw new ParseException(String.format("can't parse string [%s]", jsonString), e);
        }
    }

    public static final class ParseException
    extends RuntimeException {
        public ParseException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public ParseException(Throwable throwable) {
            super(throwable);
        }
    }
}

