/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.settings;

import de.agilecoders.wicket.settings.ITheme;
import de.agilecoders.wicket.util.Generics2;
import java.util.List;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class Theme
implements ITheme {
    private final String name;
    private final List<ResourceReference> resourceReferences;

    public Theme(String name, ResourceReference ... resourceReferences) {
        this.name = name;
        this.resourceReferences = Generics2.newArrayList(resourceReferences);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        for (ResourceReference resourceReference : this.resourceReferences) {
            if (resourceReference instanceof CssResourceReference) {
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)resourceReference));
                continue;
            }
            if (!(resourceReference instanceof JavaScriptResourceReference)) continue;
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)resourceReference));
        }
    }
}

