/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.settings;

import de.agilecoders.wicket.markup.html.themes.bootstrap.BootstrapResponsiveTheme;
import de.agilecoders.wicket.markup.html.themes.bootstrap.BootstrapTheme;
import de.agilecoders.wicket.settings.ITheme;
import de.agilecoders.wicket.settings.ThemeProvider;
import de.agilecoders.wicket.util.Generics2;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.Strings;

public class DefaultThemeProvider
implements ThemeProvider {
    private final List<ITheme> themes = Generics2.newArrayList(new Object[0]);
    private ITheme defaultTheme;

    public DefaultThemeProvider() {
        this.add(new BootstrapTheme());
        this.addDefaultTheme(new BootstrapResponsiveTheme());
    }

    public DefaultThemeProvider add(ITheme ... themes) {
        this.assertNoDuplicateNames(themes);
        this.themes.addAll(Generics2.newArrayList(themes));
        return this;
    }

    private void assertNoDuplicateNames(ITheme ... themes) {
        if (themes == null) {
            throw new WicketRuntimeException("list of themes is null");
        }
        for (ITheme newTheme : themes) {
            if (newTheme == null) {
                throw new WicketRuntimeException("theme is null");
            }
            for (ITheme existingTheme : this.themes) {
                if (existingTheme.equals(newTheme)) {
                    throw new WicketRuntimeException("duplicated theme entry: " + newTheme.name());
                }
                if (!newTheme.name().equalsIgnoreCase(existingTheme.name())) continue;
                throw new WicketRuntimeException("duplicated theme name: " + newTheme.name());
            }
        }
    }

    public DefaultThemeProvider addDefaultTheme(ITheme theme) {
        this.add(theme);
        return this.defaultTheme(theme);
    }

    public DefaultThemeProvider defaultTheme(ITheme theme) {
        return this.defaultTheme(theme.name());
    }

    public DefaultThemeProvider defaultTheme(String themeName) {
        ITheme newDefaultTheme = this.byName(themeName);
        if (this.defaultTheme != newDefaultTheme) {
            this.defaultTheme = newDefaultTheme;
        }
        return this;
    }

    @Override
    public ITheme byName(String name) {
        if (!Strings.isEmpty((CharSequence)name)) {
            for (ITheme theme : this.themes) {
                if (!name.equalsIgnoreCase(theme.name())) continue;
                return theme;
            }
        }
        throw new WicketRuntimeException("theme does not exists: " + name);
    }

    @Override
    public List<ITheme> available() {
        return new ArrayList<ITheme>(this.themes);
    }

    @Override
    public ITheme defaultTheme() {
        return this.defaultTheme;
    }
}

