/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.tabs;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.CssClassNameAppender;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class Collapsible
extends Panel {
    private final List<ITab> tabs;
    private final IModel<Integer> activeTab;

    public Collapsible(String markupId, List<ITab> tabs) {
        this(markupId, tabs, (IModel<Integer>)Model.of((Serializable)Integer.valueOf(0)));
    }

    public Collapsible(String markupId, List<ITab> tabs, IModel<Integer> activeTab) {
        super(markupId, activeTab);
        this.tabs = tabs;
        this.activeTab = activeTab;
        this.setOutputMarkupId(true);
        this.add(new Component[]{this.newTabList("tabs", tabs)});
        this.add(new Behavior[]{new BootstrapResourcesBehavior(), new CssClassNameAppender("accordion")});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createInitializerScript(this.getMarkupId(true))));
    }

    protected CharSequence createInitializerScript(String markupId) {
        return "$('#" + markupId + "').collapse();";
    }

    protected Component newTabList(String markupId, List<ITab> tabs) {
        return new Loop(markupId, tabs.size()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(LoopItem loopItem) {
                String parentMarkupId = Collapsible.this.getMarkupId(true);
                ITab tab = (ITab)Collapsible.this.tabs.get(loopItem.getIndex());
                Component container = Collapsible.this.newContainer("body", tab, ((Integer)Collapsible.this.activeTab.getObject()).equals(loopItem.getIndex()));
                Component title = Collapsible.this.newTitle("title", tab);
                title.add(new Behavior[]{new AttributeModifier("data-parent", (Serializable)((Object)("#" + parentMarkupId)))});
                title.add(new Behavior[]{new AttributeModifier("href", (Serializable)((Object)("#" + container.getMarkupId(true))))});
                loopItem.add(new Component[]{title});
                loopItem.add(new Component[]{container});
            }
        };
    }

    protected CssClassNameAppender getActiveCssClassNameAppender() {
        return new CssClassNameAppender("in");
    }

    protected Component newContainer(String markupId, ITab tab, boolean active) {
        WebMarkupContainer container = new WebMarkupContainer(markupId);
        container.setOutputMarkupId(true);
        container.add(new Component[]{tab.getPanel("content")});
        if (active) {
            container.add(new Behavior[]{this.getActiveCssClassNameAppender()});
        }
        return container;
    }

    protected Component newTitle(String markupId, ITab tab) {
        return new Label(markupId, tab.getTitle());
    }
}

