/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.navbar;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.markup.html.bootstrap.button.Activatable;
import de.agilecoders.wicket.markup.html.bootstrap.common.Invertible;
import de.agilecoders.wicket.markup.html.bootstrap.navbar.INavbarComponent;
import de.agilecoders.wicket.util.Behaviors;
import de.agilecoders.wicket.util.Generics2;
import de.agilecoders.wicket.util.Models;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class Navbar
extends Panel
implements Invertible<Navbar> {
    static final String COMPONENT_ID = "component";
    private static final NavbarComponentToComponentFunction NAVBAR_COMPONENT_TO_COMPONENT_FUNCTION = new NavbarComponentToComponentFunction("component");
    private static final PositionFilter POSITION_FILTER_LEFT = new PositionFilter(ComponentPosition.LEFT);
    private static final PositionFilter POSITION_FILTER_RIGHT = new PositionFilter(ComponentPosition.RIGHT);
    private IModel<String> containerModel;
    private IModel<String> invertModel;
    private CssClassNameAppender activeStateAppender;
    private final Label brandLabel;
    private final Image brandImage;
    private final IModel<Position> position = Model.of((Serializable)((Object)Position.DEFAULT));
    private final IModel<Boolean> fluid = Model.of((Serializable)Boolean.valueOf(false));
    private final List<INavbarComponent> components = new ArrayList<INavbarComponent>();

    public Navbar(String componentId) {
        this(componentId, (IModel<?>)Model.of());
    }

    public Navbar(String componentId, IModel<?> model) {
        super(componentId, model);
        TransparentWebMarkupContainer container = this.newContainer("container");
        BookmarkablePageLink<Page> brandNameLink = this.newBrandNameLink("brandName");
        this.brandLabel = this.newBrandLabel("brandLabel");
        brandNameLink.add(new Component[]{this.brandLabel});
        this.brandImage = this.newBrandImage("brandImage");
        brandNameLink.add(new Component[]{this.brandImage});
        Component leftAlignedComponentListView = this.newNavigation("navLeftList", this.newPositionDependedComponentModel(this.components, POSITION_FILTER_LEFT));
        Component rightAlignedComponentListView = this.newNavigation("navRightList", this.newPositionDependedComponentModel(this.components, POSITION_FILTER_RIGHT));
        this.activeStateAppender = new CssClassNameAppender("active");
        this.containerModel = Model.of((Serializable)((Object)""));
        this.invertModel = Model.of((Serializable)((Object)""));
        this.add(new Behavior[]{new CssClassNameAppender("navbar")});
        this.add(new Behavior[]{new CssClassNameAppender(this.invertModel)});
        this.add(new Behavior[]{new CssClassNameAppender((IModel<String>)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ((Position)Navbar.this.position.getObject()).cssClassName();
            }
        })});
        container.add(new Behavior[]{new CssClassNameAppender(this.containerModel)});
        this.add(new Component[]{container, brandNameLink, leftAlignedComponentListView, rightAlignedComponentListView});
    }

    private IModel<List<Component>> newPositionDependedComponentModel(final List<INavbarComponent> components, final PositionFilter withPosition) {
        return new LoadableDetachableModel<List<Component>>(){

            public List<Component> load() {
                return Generics2.transform(Generics2.filter(components, withPosition), NAVBAR_COMPONENT_TO_COMPONENT_FUNCTION);
            }
        };
    }

    protected Component newNavigation(String componentId, IModel<List<Component>> listModel) {
        return new ListView<Component>(componentId, listModel){

            protected void populateItem(ListItem<Component> components) {
                Activatable activatable;
                Component component = (Component)components.getModelObject();
                components.add(new Component[]{component});
                Behaviors.remove(components, (Behavior)Navbar.this.activeStateAppender);
                if (component instanceof Activatable && (activatable = (Activatable)component).isActive(component)) {
                    components.add(new Behavior[]{Navbar.this.activeStateAppender});
                }
                if (component instanceof Invertible) {
                    ((Invertible)component).setInverted(!Models.isNullOrEmpty((IModel<String>)Navbar.this.invertModel));
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(this.getList().size() > 0);
            }
        };
    }

    protected BookmarkablePageLink<Page> newBrandNameLink(String componentId) {
        return new BookmarkablePageLink<Page>(componentId, this.getHomePage()){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return Navbar.this.brandLabel.isVisible() || Navbar.this.brandImage.isVisible();
            }
        };
    }

    protected Label newBrandLabel(String markupId) {
        return new Label(markupId){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return this.getDefaultModel() != null;
            }
        };
    }

    protected Image newBrandImage(String markupId) {
        return new Image(markupId, (IModel)Model.of((Serializable)((Object)""))){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return this.getImageResourceReference() != null;
            }
        };
    }

    protected Class<? extends Page> getHomePage() {
        return this.getApplication().getHomePage();
    }

    protected void onConfigure() {
        super.onConfigure();
        this.containerModel.setObject((Object)(this.isFluid() ? "container-fluid" : "container"));
    }

    public Position getPosition() {
        return (Position)this.position.getObject();
    }

    public boolean isFluid() {
        return (Boolean)this.fluid.getObject();
    }

    public final Navbar addComponents(INavbarComponent ... components) {
        return this.addComponents(Generics2.newArrayList(components));
    }

    public final Navbar addComponents(List<INavbarComponent> components) {
        this.components.addAll(components);
        return this;
    }

    private TransparentWebMarkupContainer newContainer(String componentId) {
        return new TransparentWebMarkupContainer(componentId);
    }

    public Navbar brandName(IModel<String> brandName) {
        this.brandLabel.setDefaultModel(brandName);
        return this;
    }

    public Navbar setBrandImage(ResourceReference imageResourceReference, IModel<String> imageAltAttrModel) {
        this.brandImage.setImageResourceReference(imageResourceReference);
        if (!Models.isNullOrEmpty(imageAltAttrModel)) {
            this.brandImage.add(new Behavior[]{new AttributeModifier("alt", imageAltAttrModel)});
        }
        return this;
    }

    @Override
    public Navbar setInverted(boolean invert) {
        this.invertModel.setObject((Object)(invert ? "navbar-inverse" : ""));
        return this;
    }

    public Navbar fluid() {
        this.fluid.setObject((Object)true);
        return this;
    }

    public Navbar setPosition(Position position) {
        this.position.setObject((Object)position);
        return this;
    }

    private static final class NavbarComponentToComponentFunction
    implements Function<INavbarComponent, Component>,
    IClusterable {
        private final String markupId;

        private NavbarComponentToComponentFunction(String markupId) {
            Args.isFalse((boolean)Strings.isEmpty((CharSequence)markupId), (String)"markupId", (Object[])new Object[0]);
            this.markupId = markupId;
        }

        public Component apply(INavbarComponent navbarComponent) {
            return navbarComponent.create(this.markupId);
        }
    }

    private static final class PositionFilter
    implements Predicate<INavbarComponent>,
    IClusterable {
        private final ComponentPosition position;

        private PositionFilter(ComponentPosition position) {
            Args.notNull((Object)((Object)position), (String)"position");
            this.position = position;
        }

        public boolean apply(INavbarComponent navbarComponent) {
            return navbarComponent != null && this.position.equals((Object)navbarComponent.getPosition());
        }
    }

    public static enum ComponentPosition {
        LEFT,
        RIGHT;

    }

    public static enum Position implements ICssClassNameProvider
    {
        TOP("navbar-fixed-top"),
        STATIC_TOP("navbar-static-top"),
        BOTTOM("navbar-fixed-bottom"),
        DEFAULT("");

        private final String className;

        private Position(String className) {
            this.className = className;
        }

        @Override
        public String cssClassName() {
            return this.className;
        }
    }
}

