/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.list;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;

public class ListBehavior
extends BootstrapBaseBehavior {
    private boolean unstyled = false;
    private boolean horizontal;
    private Type type = Type.DYNAMIC;

    public ListBehavior description() {
        this.type = Type.DL;
        return this;
    }

    public ListBehavior unordered() {
        this.type = Type.UL;
        return this;
    }

    public ListBehavior ordered() {
        this.type = Type.OL;
        return this;
    }

    public ListBehavior horizontal() {
        this.horizontal = true;
        return this;
    }

    public ListBehavior unstyled() {
        this.unstyled = true;
        return this;
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.unstyled && Type.UL.equals((Object)this.type)) {
            component.add(new Behavior[]{new CssClassNameAppender("unstyled")});
        }
        if (this.horizontal && Type.DL.equals((Object)this.type)) {
            component.add(new Behavior[]{new CssClassNameAppender("dl-horizontal")});
        }
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        if (!Type.DYNAMIC.equals((Object)this.type)) {
            tag.setName(this.type.name().toLowerCase());
        }
        Components.assertTag(component, tag, "ul", "ol", "dl");
    }

    private static enum Type {
        DYNAMIC,
        OL,
        UL,
        DL;

    }
}

