/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.html;

import de.agilecoders.wicket.Bootstrap;
import de.agilecoders.wicket.markup.html.references.ModernizrJavaScriptReference;
import de.agilecoders.wicket.util.CssClassNames;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.resource.ResourceReference;

public class HtmlTag
extends TransparentWebMarkupContainer {
    private final boolean useModernizr;
    private final Locale locale;
    private final ClientProperties clientProperties;

    public HtmlTag(String markupId, Locale locale, boolean useModernizr) {
        super(markupId);
        this.locale = locale;
        this.useModernizr = useModernizr;
        this.clientProperties = this.newWebClientInfo();
    }

    public HtmlTag(String markupId, boolean useModernizr) {
        this(markupId, Locale.ENGLISH, useModernizr);
    }

    public HtmlTag(String markupId, Locale locale) {
        this(markupId, locale, false);
    }

    public HtmlTag(String markupId) {
        this(markupId, Locale.ENGLISH, false);
    }

    protected ClientProperties newWebClientInfo() {
        return new WebClientInfo(this.getRequestCycle()).getProperties();
    }

    private String toAttributeValue(Locale locale) {
        return locale.toString().replace("_", "-").toLowerCase();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "html");
        if (this.locale != null) {
            tag.put("lang", (CharSequence)this.toAttributeValue(this.locale));
        }
        CssClassNames.Builder cssClassNames = CssClassNames.newBuilder();
        if (this.useModernizr) {
            cssClassNames.add("no-js");
        }
        cssClassNames.add(this.createBrowserShortcut(this.clientProperties));
        cssClassNames.add("theme-" + Bootstrap.getSettings().getActiveThemeProvider().getActiveTheme().name());
        tag.put("class", (CharSequence)cssClassNames.asString());
    }

    private Set<String> createBrowserShortcut(ClientProperties clientProperties) {
        HashSet<String> shortcut = new HashSet<String>();
        if (clientProperties.isBrowserInternetExplorer() && clientProperties.getBrowserVersionMajor() < 9) {
            shortcut.add("lt-ie9");
            if (clientProperties.getBrowserVersionMajor() < 8) {
                shortcut.add("lt-ie8");
                if (clientProperties.getBrowserVersionMajor() < 7) {
                    shortcut.add("lt-ie7");
                }
            }
        }
        return shortcut;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.useModernizr) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)ModernizrJavaScriptReference.INSTANCE));
        }
    }
}

