/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.form;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.CssClassNameAppender;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class ControlGroupBorder
extends Border {
    private Label feedback;
    private Label label;
    private Label help;

    public ControlGroupBorder(String id) {
        super(id);
        this.commonInit();
    }

    public ControlGroupBorder(String id, IModel<?> model) {
        super(id, model);
        this.commonInit();
    }

    private void commonInit() {
        this.feedback = new Label("feedback", (IModel)new Model());
        this.label = new Label("label", (IModel)new Model());
        this.help = new Label("help", (IModel)new Model());
        this.addToBorder(new Component[]{this.feedback, this.label, this.help});
    }

    public ControlGroupBorder label(IModel<String> labelModel) {
        this.label.setDefaultModel(labelModel);
        return this;
    }

    public ControlGroupBorder help(IModel<String> helpModel) {
        this.help.setDefaultModel(helpModel);
        return this;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        List<FeedbackMessage> feedbackMessageList = this.collectFeedbackMessages();
        if (feedbackMessageList != null && !feedbackMessageList.isEmpty()) {
            FeedbackMessage feedbackMessage = feedbackMessageList.get(0);
            this.feedback.setDefaultModel((IModel)new Model(feedbackMessage.getMessage()));
            this.feedback.setVisible(true);
            this.add(new Behavior[]{new CssClassNameAppender(feedbackMessage.getLevelAsString().toLowerCase())});
        } else {
            this.feedback.setVisible(false);
        }
        this.label.setVisible(!Strings.isEmpty((CharSequence)this.label.getDefaultModelObjectAsString()));
        this.help.setVisible(!Strings.isEmpty((CharSequence)this.help.getDefaultModelObjectAsString()));
    }

    private List<FeedbackMessage> collectFeedbackMessages() {
        return this.getSession().getFeedbackMessages().messages(this.newMessagesFilter());
    }

    protected IFeedbackMessageFilter newMessagesFilter() {
        return new ContainerFeedbackMessageFilter((MarkupContainer)this);
    }
}

