/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.form;

import de.agilecoders.wicket.util.Attributes;
import de.agilecoders.wicket.util.Components;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormModelUpdateListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.iterator.ComponentHierarchyIterator;

public class ControlGroup
extends Border
implements IFormModelUpdateListener {
    private final Label label;
    private final Label help;
    private final Label error;
    private final Model<String> stateClassName;

    public ControlGroup(String id, IModel<String> label) {
        this(id, label, (IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public ControlGroup(String id, IModel<String> label, IModel<String> help) {
        super(id, (IModel)Model.of((Serializable)((Object)"")));
        this.label = new Label("label", label);
        this.help = new Label("help", help);
        this.error = new Label("error", (IModel)Model.of((Serializable)((Object)"")));
        this.stateClassName = Model.of((Serializable)((Object)""));
        this.addToBorder(new Component[]{this.label, this.help, this.error});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass(tag, "control-group", (String)((Object)this.stateClassName.getObject()));
    }

    public ControlGroup label(IModel<String> label) {
        this.label.setDefaultModel(label);
        return this;
    }

    public ControlGroup help(IModel<String> help) {
        this.help.setDefaultModel(help);
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        List<FormComponent<?>> formComponents = this.findFormComponents();
        for (FormComponent<?> fc : formComponents) {
            fc.setOutputMarkupId(true);
            this.label.add(new Behavior[]{new AttributeModifier("for", (Serializable)((Object)fc.getMarkupId()))});
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        Components.show(new Component[]{this.help, this.label, this.error});
        this.stateClassName.setObject((Serializable)((Object)""));
        this.error.setDefaultModelObject((Object)"");
        List<FormComponent<?>> formComponents = this.findFormComponents();
        for (FormComponent<?> fc : formComponents) {
            FeedbackMessages messages = fc.getFeedbackMessages();
            if (messages.isEmpty()) continue;
            FeedbackMessage worstMessage = this.getWorstMessage(messages);
            worstMessage.markRendered();
            this.stateClassName.setObject((Serializable)((Object)this.toClassName(worstMessage)));
            this.error.setDefaultModelObject((Object)worstMessage.getMessage());
            break;
        }
        Components.hideIfModelIsEmpty((Component)this.help);
        Components.hideIfModelIsEmpty((Component)this.label);
        Components.hideIfModelIsEmpty((Component)this.error);
    }

    private List<FormComponent<?>> findFormComponents() {
        ComponentHierarchyIterator it = this.getBodyContainer().visitChildren(FormComponent.class);
        ArrayList components = new ArrayList();
        while (it.hasNext()) {
            components.add((FormComponent)it.next());
        }
        return components;
    }

    private FeedbackMessage getWorstMessage(FeedbackMessages messages) {
        FeedbackMessage ret = messages.first(500);
        if (ret != null) {
            return ret;
        }
        ret = messages.first(400);
        if (ret != null) {
            return ret;
        }
        ret = messages.first(300);
        if (ret != null) {
            return ret;
        }
        ret = messages.first(250);
        if (ret != null) {
            return ret;
        }
        ret = messages.first(200);
        if (ret != null) {
            return ret;
        }
        ret = messages.first(100);
        if (ret != null) {
            return ret;
        }
        ret = messages.first(0);
        if (ret != null) {
            return ret;
        }
        return messages.first();
    }

    private String toClassName(FeedbackMessage message) {
        if (message.isLevel(400)) {
            return "error";
        }
        if (message.isLevel(300)) {
            return "warning";
        }
        if (message.isLevel(250)) {
            return "success";
        }
        if (message.isLevel(200)) {
            return "info";
        }
        return "";
    }

    public void updateModel() {
        List<FormComponent<?>> formComponents = this.findFormComponents();
        for (FormComponent<?> formComponent : formComponents) {
            formComponent.updateModel();
        }
    }
}

