/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.dialog;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.markup.html.bootstrap.dialog.ModalCloseButton;
import de.agilecoders.wicket.util.Attributes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class Modal
extends Panel {
    public static final String BUTTON_MARKUP_ID = "button";
    private final WebMarkupContainer header;
    private final IModel<Boolean> show = Model.of((Serializable)Boolean.valueOf(false));
    private final IModel<Boolean> fadein = Model.of((Serializable)Boolean.valueOf(true));
    private final IModel<Boolean> keyboard = Model.of((Serializable)Boolean.valueOf(true));
    private final Label headerLabel;
    private final List<Component> buttons = new ArrayList<Component>();
    private final WebMarkupContainer footer;
    private final IModel<Boolean> useCloseHandler = Model.of((Serializable)Boolean.valueOf(false));
    private final AjaxEventBehavior closeBehavior;

    public Modal(String markupId) {
        this(markupId, null);
    }

    public Modal(String id, IModel<String> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.setOutputMarkupPlaceholderTag(true);
        this.footer = new WebMarkupContainer("footer");
        this.header = new WebMarkupContainer("header");
        Component[] componentArray = new Component[1];
        this.headerLabel = new Label("header-label", "");
        componentArray[0] = this.headerLabel;
        this.header.add(componentArray);
        this.footer.add(new Component[]{new ListView<Component>("buttons", this.buttons){

            protected void populateItem(ListItem<Component> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        }});
        this.closeBehavior = new AjaxEventBehavior("hidden"){

            protected void onEvent(AjaxRequestTarget target) {
                Modal.this.handleCloseEvent(target);
            }
        };
        this.add(new Component[]{this.header, this.footer});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass(tag, "modal", "hide");
        Attributes.set(tag, "tabindex", "-1");
    }

    protected void onClose(AjaxRequestTarget target) {
    }

    public Modal header(IModel<String> label) {
        this.headerLabel.setDefaultModel(label);
        this.setHeaderVisible(true);
        return this;
    }

    public Modal header(IModel<String> label, boolean escapeMarkup) {
        this.headerLabel.setDefaultModel(label);
        this.headerLabel.setEscapeModelStrings(escapeMarkup);
        return this;
    }

    public Modal setFooterVisible(boolean visible) {
        this.footer.setVisible(visible);
        return this;
    }

    public Modal setHeaderVisible(boolean visible) {
        this.header.setVisible(visible);
        return this;
    }

    public final Modal setUseCloseHandler(boolean useCloseHandler) {
        this.useCloseHandler.setObject((Object)useCloseHandler);
        return this;
    }

    public Modal show(boolean show) {
        this.show.setObject((Object)show);
        return this;
    }

    public Modal appendCloseDialogJavaScript(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)this.createActionScript(this.getMarkupId(true), "hide"));
        return this;
    }

    public Modal appendShowDialogJavaScript(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)this.createActionScript(this.getMarkupId(true), "show"));
        return this;
    }

    protected String createActionScript(String markupId, String action) {
        return "$('#" + markupId + "').modal('" + action + "');";
    }

    public Modal addOpenerAttributesTo(Component component) {
        component.add(new Behavior[]{new AttributeModifier("data-toggle", (Serializable)((Object)"modal"))});
        component.add(new Behavior[]{new AttributeModifier("href", (Serializable)((Object)("#" + this.getMarkupId(true))))});
        return this;
    }

    public Modal addCloseButton(IModel<String> label) {
        ModalCloseButton button = new ModalCloseButton(label);
        button.setAnchor((Component)this);
        return this.addButton((Component)button);
    }

    public Modal addCloseButton() {
        return this.addCloseButton((IModel<String>)Model.of((Serializable)((Object)"Close")));
    }

    public Modal addButton(Component button) {
        if (!BUTTON_MARKUP_ID.equals(button.getId())) {
            throw new IllegalArgumentException(String.format("Invalid button markup id. Must be '%s'.", BUTTON_MARKUP_ID));
        }
        if (button instanceof ModalCloseButton) {
            // empty if block
        }
        this.buttons.add(button);
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        if (((Boolean)this.useCloseHandler.getObject()).booleanValue()) {
            this.add(new Behavior[]{this.closeBehavior});
        }
    }

    private void handleCloseEvent(AjaxRequestTarget target) {
        if (this.isVisible()) {
            this.onClose(target);
            this.appendCloseDialogJavaScript(target);
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.useFadein()) {
            this.add(new Behavior[]{new CssClassNameAppender("fade")});
        }
        if (Strings.isEmpty((CharSequence)this.headerLabel.getDefaultModelObjectAsString())) {
            this.headerLabel.setDefaultModelObject((Object)"&nbsp;");
            this.headerLabel.setEscapeModelStrings(false);
        }
        this.footer.setVisible(this.buttons.size() > 0);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createInitializerScript(this.getMarkupId(true))));
    }

    private String createInitializerScript(String markupId) {
        return this.addCloseHandlerScript(markupId, this.createBasicInitializerScript(markupId));
    }

    protected String createBasicInitializerScript(String markupId) {
        return "$('#" + markupId + "').modal({keyboard:" + this.useKeyboard() + ", show:" + this.showImmediately() + "})";
    }

    private String addCloseHandlerScript(String markupId, String script) {
        if (((Boolean)this.useCloseHandler.getObject()).booleanValue()) {
            return script + ";$('#" + markupId + "').on('hidden', function () { " + "  Wicket.Ajax.ajax({'u':'" + this.closeBehavior.getCallbackUrl() + "','c':'" + markupId + "'});" + "})";
        }
        return script;
    }

    protected final boolean useFadein() {
        return (Boolean)this.fadein.getObject();
    }

    protected final boolean useKeyboard() {
        return (Boolean)this.keyboard.getObject();
    }

    protected final boolean showImmediately() {
        return (Boolean)this.show.getObject();
    }

    public final Modal setFadeIn(boolean fadein) {
        this.fadein.setObject((Object)fadein);
        return this;
    }

    public final Modal setUseKeyboard(boolean keyboard) {
        this.keyboard.setObject((Object)keyboard);
        return this;
    }
}

