/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.dialog;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public class Alert
extends GenericPanel<String> {
    private final WebMarkupContainer closeButton;
    private final Component message;
    private final Label blockHeader;
    private final Label inlineHeader;
    private final IModel<Type> type = Model.of((Serializable)((Object)Type.Info));
    private Duration duration;
    private boolean useInlineHeader = true;

    public Alert(String id, IModel<String> message) {
        this(id, message, (IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public Alert(String id, IModel<String> message, IModel<String> header) {
        super(id, message);
        this.inlineHeader = new Label("inline", header);
        this.blockHeader = new Label("block", header);
        this.message = this.createMessage("message", (IModel<String>)this.getModel());
        this.closeButton = new WebMarkupContainer("close");
        this.add(new Component[]{this.inlineHeader, this.blockHeader, this.message, this.closeButton});
        BootstrapBaseBehavior.addTo((Component)this);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass(tag, "alert");
        Attributes.addClass(tag, (ICssClassNameProvider)this.type.getObject());
    }

    protected Component createMessage(String markupId, IModel<String> message) {
        return new Label(markupId, message);
    }

    public Alert setCloseButtonVisible(boolean visible) {
        this.closeButton.setVisible(visible);
        return this;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.duration != null && this.duration.seconds() > 0.0) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("window.setTimeout(function(){ $('#" + this.getMarkupId() + "').alert('close');}," + this.duration.getMilliseconds() + ");")));
        }
    }

    public Alert withMessage(IModel<String> message) {
        this.setDefaultModel(message);
        return this;
    }

    public Alert withHeader(IModel<String> header) {
        this.blockHeader.setDefaultModel(header);
        this.inlineHeader.setDefaultModel(header);
        return this;
    }

    public Alert type(Type type) {
        this.type.setObject((Object)type);
        return this;
    }

    public Alert hideAfter(Duration duration) {
        this.duration = duration;
        return this;
    }

    public Alert useInlineHeader(boolean useInlineHeader) {
        this.useInlineHeader = useInlineHeader;
        return this;
    }

    protected void onConfigure() {
        super.onConfigure();
        if (Strings.isEmpty((CharSequence)this.inlineHeader.getDefaultModelObjectAsString())) {
            this.inlineHeader.setVisible(false);
            this.blockHeader.setVisible(false);
        } else {
            this.inlineHeader.setVisible(this.useInlineHeader);
            this.blockHeader.setVisible(!this.useInlineHeader);
        }
        this.message.setDefaultModel(this.getDefaultModel());
        if (this.closeButton.isVisible()) {
            this.add(new Behavior[]{BootstrapResourcesBehavior.instance()});
        }
    }

    public static enum Type implements ICssClassNameProvider
    {
        Error,
        Success,
        Info,
        Warning;


        @Override
        public String cssClassName() {
            return this.equals(Warning) ? "alert-block" : "alert-" + this.name().toLowerCase();
        }

        public static Type from(String level) {
            if (level.equalsIgnoreCase("ERROR") || level.equalsIgnoreCase("FATAL")) {
                return Error;
            }
            if (level.equalsIgnoreCase("WARNING")) {
                return Warning;
            }
            if (level.equalsIgnoreCase("SUCCESS")) {
                return Success;
            }
            return Info;
        }
    }
}

