/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.components;

import de.agilecoders.wicket.markup.html.bootstrap.common.AbstractConfig;
import org.apache.wicket.util.time.Duration;

public class TooltipConfig
extends AbstractConfig {
    private static final AbstractConfig.IKey<Boolean> Animation = TooltipConfig.newKey("animation", true);
    private static final AbstractConfig.IKey<String> TooltipPlacement = TooltipConfig.newKey("placement", "top");
    private static final AbstractConfig.IKey<String> Selector = TooltipConfig.newKey("selector", "false");
    private static final AbstractConfig.IKey<String> Content = TooltipConfig.newKey("content", "");
    private static final AbstractConfig.IKey<String> Title = TooltipConfig.newKey("title", "");
    private static final AbstractConfig.IKey<String> Trigger = TooltipConfig.newKey("trigger", "hover");
    private static final AbstractConfig.IKey<Long> Delay = TooltipConfig.newKey("delay", 0L);
    private static final AbstractConfig.IKey<Boolean> Html = TooltipConfig.newKey("html", false);

    public TooltipConfig withAnimation(boolean value) {
        this.put(Animation, value);
        return this;
    }

    public TooltipConfig withPlacement(IPlacement value) {
        this.put(TooltipPlacement, value.value());
        return this;
    }

    public TooltipConfig withSelector(String value) {
        this.put(Selector, value);
        return this;
    }

    public TooltipConfig withTitle(String value) {
        this.put(Title, value);
        return this;
    }

    public TooltipConfig withContent(String value) {
        this.put(Content, value);
        return this;
    }

    public TooltipConfig withTrigger(OpenTrigger value) {
        this.put(Trigger, value.name());
        return this;
    }

    public TooltipConfig withDelay(Duration value) {
        this.put(Delay, value.getMilliseconds());
        return this;
    }

    public TooltipConfig withHtml(boolean value) {
        this.put(Html, value);
        return this;
    }

    public static enum OpenTrigger {
        click,
        hover,
        focus,
        manual;

    }

    public static interface IPlacement {
        public String value();
    }

    public static enum Placement implements IPlacement
    {
        top,
        bottom,
        right,
        left;


        @Override
        public String value() {
            return this.name();
        }
    }
}

