/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.common;

import de.agilecoders.wicket.util.ConfigModel;
import de.agilecoders.wicket.util.Json;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Objects;

public abstract class AbstractConfig
implements IClusterable {
    private final Map<String, Object> config = new HashMap<String, Object>();

    protected AbstractConfig() {
    }

    public final String toJsonString() {
        return Json.stringify(this.config);
    }

    public final Map<String, Object> all() {
        return new HashMap<String, Object>(this.config);
    }

    public final boolean isEmpty() {
        return this.config.isEmpty();
    }

    protected final <T> AbstractConfig put(IKey<T> key, T value) {
        if (!key.isDefaultValue(value)) {
            this.config.put(key.key(), value);
        } else {
            this.remove(key);
        }
        return this;
    }

    protected final <T> T remove(IKey<T> key) {
        return (T)this.config.remove(key.key());
    }

    protected final <T> String getString(IKey<T> key) {
        Object value = this.config.get(key.key());
        return String.valueOf(value != null ? value : key.getDefaultValue());
    }

    protected ConfigModel wrap(IModel<String> model) {
        return new ConfigModel(model);
    }

    protected static <T> IKey<T> newKey(String key, T defaultValue) {
        return new Key(key, defaultValue);
    }

    private static final class Key<T>
    implements IKey<T> {
        private final String key;
        private final T defaultValue;

        private Key(String key, T defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public boolean isDefaultValue(T value) {
            return Objects.equal(value, this.defaultValue);
        }

        @Override
        public T getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static interface IKey<T> {
        public String key();

        public boolean isDefaultValue(T var1);

        public T getDefaultValue();
    }
}

