/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.button;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.markup.html.bootstrap.button.ButtonList;
import de.agilecoders.wicket.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.util.Attributes;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.lang.Args;

public abstract class ButtonGroup
extends Panel {
    private final Buttons.Orientation orientation;

    public ButtonGroup(String markupId) {
        this(markupId, Buttons.Orientation.Horizontal);
    }

    public ButtonGroup(String markupId, Buttons.Orientation orientation) {
        super(markupId);
        Args.notNull((Object)orientation, (String)"orientation");
        this.orientation = orientation;
        this.add(new Component[]{this.newButtonList("buttons")});
        BootstrapBaseBehavior.addTo((Component)this);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Attributes.addClass(tag, this.orientation.cssClassName(), "btn-group");
    }

    protected ButtonList newButtonList(String markupId) {
        ButtonList buttonList = new ButtonList(markupId, this.newButtons(ButtonList.getButtonMarkupId()));
        buttonList.setRenderBodyOnly(true);
        return buttonList;
    }

    protected abstract List<AbstractLink> newButtons(String var1);
}

