/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.block;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.markup.html.bootstrap.block.LabelType;
import de.agilecoders.wicket.util.Attributes;
import de.agilecoders.wicket.util.Components;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class LabelBehavior
extends Behavior {
    private final IModel<LabelType> type;

    public LabelBehavior() {
        this(LabelType.Default);
    }

    public LabelBehavior(LabelType type) {
        this((IModel<LabelType>)Model.of((Serializable)((Object)type)));
    }

    public LabelBehavior(IModel<LabelType> type) {
        this.type = type;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Components.assertTag(component, tag, "span");
        Attributes.addClass(tag, this.className(), this.getType().cssClassName(this.className()));
    }

    public final LabelType getType() {
        return (LabelType)this.type.getObject();
    }

    public final LabelBehavior setType(LabelType type) {
        this.type.setObject((Object)type);
        return this;
    }

    protected String className() {
        return "label";
    }

    public void bind(Component component) {
        super.bind(component);
        BootstrapBaseBehavior.addTo(component);
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom(component);
    }
}

