/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html;

import de.agilecoders.wicket.Bootstrap;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.head.filter.AbstractHeaderResponseFilter;
import org.apache.wicket.markup.head.filter.FilteringHeaderResponse;
import org.apache.wicket.markup.head.filter.OppositeHeaderResponseFilter;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;
import org.apache.wicket.util.lang.Args;

public class RenderJavaScriptToFooterHeaderResponseDecorator
implements IHeaderResponseDecorator {
    final List<FilteringHeaderResponse.IHeaderResponseFilter> filters;

    public RenderJavaScriptToFooterHeaderResponseDecorator() {
        this(Bootstrap.getSettings().getJsResourceFilterName());
    }

    public RenderJavaScriptToFooterHeaderResponseDecorator(String filterName) {
        Args.notEmpty((CharSequence)filterName, (String)"filterName");
        this.filters = new ArrayList<FilteringHeaderResponse.IHeaderResponseFilter>();
        AbstractHeaderResponseFilter jsAcceptingFilter = new AbstractHeaderResponseFilter(filterName){

            public boolean accepts(HeaderItem item) {
                return item instanceof JavaScriptHeaderItem || item instanceof OnDomReadyHeaderItem || item instanceof OnLoadHeaderItem;
            }
        };
        this.filters.add((FilteringHeaderResponse.IHeaderResponseFilter)jsAcceptingFilter);
        this.filters.add((FilteringHeaderResponse.IHeaderResponseFilter)new OppositeHeaderResponseFilter("headBucket", (FilteringHeaderResponse.IHeaderResponseFilter)jsAcceptingFilter));
    }

    public IHeaderResponse decorate(IHeaderResponse response) {
        return new FilteringHeaderResponse(response, "headBucket", this.filters);
    }
}

