/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.settings.IBootstrapSettings;
import de.agilecoders.wicket.webjars.util.WicketWebjars;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.markup.html.SecurePackageResourceGuard;
import org.apache.wicket.settings.IMarkupSettings;

public final class Bootstrap {
    private static final MetaDataKey<IBootstrapSettings> BOOTSTRAP_SETTINGS_METADATA_KEY = new MetaDataKey<IBootstrapSettings>(){};

    private Bootstrap() {
        throw new UnsupportedOperationException();
    }

    public static void install(Application app, IBootstrapSettings settings) {
        app.setMetaData(BOOTSTRAP_SETTINGS_METADATA_KEY, (Object)settings);
        if (settings.updateSecurityManager()) {
            Bootstrap.updateSecurityManager(app);
        }
        Bootstrap.configureMarkupSettings(app);
        WicketWebjars.install((Application)app);
    }

    private static void configureMarkupSettings(Application application) {
        IMarkupSettings markupSettings = application.getMarkupSettings();
        markupSettings.setStripWicketTags(true);
    }

    private static void updateSecurityManager(Application app) {
        IPackageResourceGuard packageResourceGuard = app.getResourceSettings().getPackageResourceGuard();
        if (packageResourceGuard instanceof SecurePackageResourceGuard) {
            SecurePackageResourceGuard guard = (SecurePackageResourceGuard)packageResourceGuard;
            guard.addPattern("+*.woff");
            guard.addPattern("+*.eot");
            guard.addPattern("+*.svg");
            guard.addPattern("+*.ttf");
        }
    }

    public static IBootstrapSettings getSettings(Application app) {
        return (IBootstrapSettings)app.getMetaData(BOOTSTRAP_SETTINGS_METADATA_KEY);
    }

    public static IBootstrapSettings getSettings() {
        if (Application.exists()) {
            return Bootstrap.getSettings(Application.get());
        }
        throw new IllegalStateException("there is no active application assigned to this thread.");
    }

    public static void renderHead(Component component, IHeaderResponse response) {
        BootstrapResourcesBehavior.instance().renderHead(Bootstrap.getSettings(component.getApplication()), response);
    }

    public static void renderHead(IHeaderResponse response) {
        BootstrapResourcesBehavior.instance().renderHead(Bootstrap.getSettings(Application.get()), response);
    }
}

