/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components.progress;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.Stack;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.UploadProgressBarJavaScriptReference;
import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressBar
extends GenericPanel<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressBar.class);
    public static final int MIN = 0;
    public static final int MAX = 100;
    private final RepeatingView stacks;
    private boolean active = false;
    private boolean striped = false;

    public ProgressBar(String id) {
        this(id, null);
    }

    public ProgressBar(String id, IModel<Integer> model) {
        this(id, model, Type.DEFAULT, false);
    }

    public ProgressBar(String id, IModel<Integer> model, Type type) {
        this(id, model, type, false);
    }

    public ProgressBar(String id, IModel<Integer> model, boolean labeled) {
        this(id, model, Type.DEFAULT, labeled);
    }

    public ProgressBar(String id, IModel<Integer> model, Type type, boolean labeled) {
        super(id, model);
        Args.notNull((Object)type, (String)"type");
        this.stacks = new RepeatingView("stacks");
        this.add(new Component[]{this.stacks});
        if (model != null) {
            Stack defaultStack = new Stack(this.getStackId(), (IModel<Integer>)new AbstractReadOnlyModel<Integer>(){

                public Integer getObject() {
                    return (Integer)ProgressBar.this.getModelObject();
                }
            });
            defaultStack.type(type).labeled(labeled);
            this.addStacks(defaultStack);
        }
    }

    public String getStackId() {
        return this.stacks.newChildId();
    }

    public ProgressBar addStacks(Stack ... _stacks) {
        Args.notNull((Object)_stacks, (String)"_stacks");
        for (Stack stack : _stacks) {
            this.stacks.add(new Component[]{stack});
        }
        return this;
    }

    public boolean striped() {
        return this.striped;
    }

    public ProgressBar striped(boolean value) {
        this.striped = value;
        return this;
    }

    public boolean active() {
        return this.active;
    }

    public ProgressBar active(boolean value) {
        this.active = value;
        if (value) {
            this.striped(true);
        }
        return this;
    }

    public final boolean complete() {
        return this.value() == 100;
    }

    public ProgressBar value(IModel<Integer> value) {
        this.setDefaultModel(value);
        return this;
    }

    public ProgressBar value(Integer value) {
        if (value < 0) {
            LOG.warn("The provided value '{}' is smaller than the allowed minimum '{}'.", (Object)value, (Object)0);
            value = 0;
        } else if (value > 100) {
            LOG.warn("The provided value '{}' is bigger than the allowed maximum'{}'.", (Object)value, (Object)100);
            value = 100;
        }
        this.setDefaultModelObject(value);
        return this;
    }

    public Integer value() {
        Integer value = (Integer)this.getModelObject();
        if (value < 0) {
            LOG.warn("The model object '{}' is smaller than the allowed minimum '{}'.", (Object)value, (Object)0);
            value = 0;
        } else if (value > 100) {
            LOG.warn("The model object '{}' is bigger than the allowed maximum'{}'.", (Object)value, (Object)100);
            value = 100;
        }
        return value;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        ProgressBar.internalOnComponentTag(tag, this.active(), this.striped());
    }

    static void internalOnComponentTag(ComponentTag tag, boolean isActive, boolean isStriped) {
        if (!"div".equalsIgnoreCase(tag.getName())) {
            LOG.warn("You've added a progress bar component to a non 'div' tag: {}. Changing it to 'div'!", (Object)tag.getName());
            tag.setName("div");
        }
        Attributes.addClass(tag, "progress");
        if (isActive) {
            Attributes.addClass(tag, "active");
        }
        if (isStriped) {
            Attributes.addClass(tag, "progress-striped");
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new UploadProgressBarJavaScriptReference()));
    }

    public static enum Type implements ICssClassNameProvider
    {
        DEFAULT,
        INFO,
        SUCCESS,
        WARNING,
        DANGER;


        @Override
        public String cssClassName() {
            return this.equals(DEFAULT) ? "" : "progress-bar-" + this.name().toLowerCase();
        }
    }
}

