/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.AlignmentBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Activatable;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonList;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.DropDownJqueryFunction;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import de.agilecoders.wicket.jquery.JQuery;
import de.agilecoders.wicket.jquery.function.IFunction;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public abstract class DropDownButton
extends AbstractLink
implements Activatable {
    private final IModel<Buttons.Size> buttonSize = Model.of((Serializable)((Object)Buttons.Size.Medium));
    private final IModel<Buttons.Type> buttonType = Model.of((Serializable)((Object)Buttons.Type.Default));
    private final ButtonList buttonListView;
    private final WebMarkupContainer baseButton;
    private final Icon icon;
    private final IModel<AlignmentBehavior.Alignment> alignment = Model.of((Serializable)((Object)AlignmentBehavior.Alignment.NONE));
    private boolean dropUp = false;

    public DropDownButton(String id, IModel<String> model) {
        this(id, model, (IModel<IconType>)Model.of((Serializable)((Object)((IconType)null))));
    }

    public DropDownButton(String markupId, IModel<String> model, IModel<IconType> iconTypeModel) {
        super(markupId, model);
        Component[] componentArray = new Component[1];
        this.baseButton = this.newButton("btn", model, iconTypeModel);
        componentArray[0] = this.baseButton;
        this.add(componentArray);
        WebMarkupContainer dropdownMenu = new WebMarkupContainer("dropdown-menu");
        dropdownMenu.add(new Behavior[]{new AlignmentBehavior(this.alignment)});
        this.add(new Component[]{dropdownMenu});
        Component[] componentArray2 = new Component[1];
        this.buttonListView = this.newButtonList("buttons");
        componentArray2[0] = this.buttonListView;
        dropdownMenu.add(componentArray2);
        this.icon = this.newButtonIcon("icon", iconTypeModel);
        BootstrapResourcesBehavior.addTo((Component)this);
        this.addIconToBaseButton(this.icon);
        this.addButtonBehavior(this.buttonType, this.buttonSize);
    }

    protected String createCssClassName() {
        return "dropdown";
    }

    protected void addIconToBaseButton(Icon icon) {
        this.baseButton.add(new Component[]{icon});
    }

    public final DropDownButton addToButton(Behavior behavior) {
        this.baseButton.add(new Behavior[]{behavior});
        return this;
    }

    protected String newInitializerScript() {
        JQuery jQuery = JQuery.$((Component)this.baseButton);
        return jQuery.chain((IFunction)DropDownJqueryFunction.dropdown()).get();
    }

    public final void appendToggleMenuScript(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)JQuery.$((Component)this, (CharSequence[])new CharSequence[]{".dropdown-toggle"}).chain((IFunction)DropDownJqueryFunction.dropdown("toggle")).get());
    }

    public final DropDownButton setIconType(IconType iconType) {
        this.icon.setType(iconType);
        return this;
    }

    protected WebMarkupContainer newButton(String markupId, IModel<String> labelModel, IModel<IconType> iconTypeModel) {
        WebMarkupContainer baseButton = new WebMarkupContainer(markupId);
        baseButton.setOutputMarkupId(true);
        baseButton.add(new Component[]{this.newButtonLabel("label", labelModel)});
        return baseButton;
    }

    protected Component newButtonLabel(String markupId, IModel<?> labelModel) {
        Label label = new Label(markupId, labelModel);
        label.setRenderBodyOnly(true);
        return label;
    }

    protected Icon newButtonIcon(String markupId, IModel<IconType> iconTypeModel) {
        return new Icon(markupId, iconTypeModel);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String script = this.newInitializerScript();
        if (!Strings.isEmpty((CharSequence)script)) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
        }
    }

    protected void addButtonBehavior(IModel<Buttons.Type> buttonType, IModel<Buttons.Size> buttonSize) {
        this.baseButton.add(new Behavior[]{new ButtonBehavior(buttonType, buttonSize)});
    }

    protected abstract List<AbstractLink> newSubMenuButtons(String var1);

    private ButtonList newButtonList(String markupId) {
        ButtonList buttonList = new ButtonList(markupId, this.newSubMenuButtons(ButtonList.getButtonMarkupId()));
        buttonList.setRenderBodyOnly(true);
        return buttonList;
    }

    public DropDownButton setDropUp(boolean dropUp) {
        this.dropUp = dropUp;
        return this;
    }

    public DropDownButton setSize(Buttons.Size size) {
        this.buttonSize.setObject((Object)size);
        return this;
    }

    public DropDownButton setType(Buttons.Type type) {
        this.buttonType.setObject((Object)type);
        return this;
    }

    public DropDownButton setAlignment(AlignmentBehavior.Alignment alignment) {
        this.alignment.setObject((Object)alignment);
        return this;
    }

    protected final IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(false);
    }

    protected void onComponentTag(ComponentTag tag) {
        if (!Components.hasTagName(tag, "div", "li")) {
            tag.setName("div");
        }
        super.onComponentTag(tag);
        if (this.dropUp) {
            Attributes.addClass(tag, "dropup");
        }
        Attributes.addClass(tag, this.createCssClassName());
    }

    @Override
    public boolean isActive(Component item) {
        return this.buttonListView.hasActiveButton(item);
    }
}

