/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery;

import com.google.common.base.Function;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IFunction;
import de.agilecoders.wicket.jquery.util.Generics2;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public final class JQuery
implements IClusterable {
    private static final Function<IFunction, String> FUNCTION_TRANSFORMER = new Function<IFunction, String>(){

        public String apply(IFunction function) {
            return function != null ? function.build() : null;
        }
    };
    private final String selector;
    private final List<IFunction> functions;

    public static JQuery $(String selector) {
        return new JQuery(selector);
    }

    public static JQuery $(Component component) {
        CharSequence escapedMarkupId = Strings2.getMarkupId(component);
        return JQuery.$("#" + escapedMarkupId);
    }

    public static JQuery $(Component component, String ... additionalSelector) {
        CharSequence markupId = Strings2.getMarkupId(component);
        ArrayList<String> selector = Generics2.newArrayList("#" + markupId);
        if (additionalSelector != null) {
            selector.addAll(Generics2.newArrayList(additionalSelector));
        }
        return JQuery.$(Generics2.join(selector, ' '));
    }

    public JQuery on(String events, JavaScriptInlineFunction handler) {
        return this.chain(OnJqueryFunction.on(events, handler));
    }

    public JQuery on(String events, String selector, JavaScriptInlineFunction handler) {
        return this.chain(OnJqueryFunction.on(events, selector, handler));
    }

    public JQuery closest(String selector) {
        return this.chain(ClosestJqueryFunction.closest(selector));
    }

    private JQuery(String selector) {
        this.selector = selector;
        this.functions = Generics2.newArrayList(new Object[0]);
    }

    public JQuery chain(IFunction function) {
        this.functions.add(function);
        return this;
    }

    public JQuery chain(String functionName) {
        this.functions.add(new SimpleFunction(functionName));
        return this;
    }

    public String get() {
        return "$('" + this.selector + "')" + this.createFunctionString() + ";";
    }

    public OnDomReadyHeaderItem asDomReadyScript() {
        return OnDomReadyHeaderItem.forScript((CharSequence)this.get());
    }

    private String createFunctionString() {
        return this.functions.isEmpty() ? "" : "." + Generics2.join(Generics2.transform(this.functions, FUNCTION_TRANSFORMER), '.');
    }

    public JQuery chain(String functionName, AbstractConfig config) {
        this.functions.add(new ConfigurableFunction(functionName, config));
        return this;
    }

    public static abstract class AbstractFunction
    implements IFunction {
        private final String functionName;
        private final List<String> parameters;

        protected AbstractFunction(String functionName) {
            this.functionName = functionName;
            this.parameters = Generics2.newArrayList(new Object[0]);
        }

        @Override
        public String build() {
            return this.functionName + "(" + this.buildParameters() + ")";
        }

        protected final char getSeparator() {
            return ',';
        }

        protected String buildParameters() {
            return Generics2.join(this.parameters, this.getSeparator());
        }

        protected final void addParameter(String parameter) {
            this.parameters.add(parameter);
        }

        protected final String toParameterValue(Object value) {
            if (value instanceof Long) {
                return this.toParameterValue((Long)value);
            }
            if (value instanceof Integer) {
                return this.toParameterValue((Integer)value);
            }
            if (value instanceof Boolean) {
                return this.toParameterValue((Boolean)value);
            }
            if (value instanceof Float) {
                return this.toParameterValue((Float)value);
            }
            if (value instanceof JavaScriptInlineFunction) {
                return this.toParameterValue((JavaScriptInlineFunction)value);
            }
            if (value instanceof Duration) {
                return String.valueOf(((Duration)value).getMilliseconds());
            }
            return value != null ? "'" + String.valueOf(value) + "'" : "null";
        }

        protected final String toParameterValue(JavaScriptInlineFunction value) {
            return value != null ? value.build() : "null";
        }

        protected final String toParameterValue(Long value) {
            return Long.toString(value);
        }

        protected final String toParameterValue(Integer value) {
            return Integer.toString(value);
        }

        protected final String toParameterValue(Float value) {
            return Float.toString(value.floatValue());
        }

        protected final String toParameterValue(Boolean value) {
            return value != null ? Boolean.toString(value) : "null";
        }
    }

    public static final class OnJqueryFunction
    extends AbstractFunction {
        public static OnJqueryFunction on(String events, JavaScriptInlineFunction handler) {
            return new OnJqueryFunction(events, null, handler);
        }

        public static OnJqueryFunction on(String events, String selector, JavaScriptInlineFunction handler) {
            return new OnJqueryFunction(events, selector, handler);
        }

        protected OnJqueryFunction(String events, String selector, JavaScriptInlineFunction handler) {
            super("on");
            this.addParameter("'" + events + "'");
            if (!Strings.isEmpty((CharSequence)selector)) {
                this.addParameter("'" + JavaScriptUtils.escapeQuotes((CharSequence)selector) + "'");
            }
            handler.addParameter("evt");
            this.addParameter(this.toParameterValue(handler));
        }
    }

    public static final class ClosestJqueryFunction
    extends AbstractFunction {
        public static ClosestJqueryFunction closest(String selector) {
            return new ClosestJqueryFunction(selector);
        }

        protected ClosestJqueryFunction(String selector) {
            super("closest");
            this.addParameter("'" + JavaScriptUtils.escapeQuotes((CharSequence)selector) + "'");
        }
    }

    public static final class EachJqueryFunction
    extends AbstractFunction {
        public static EachJqueryFunction each(JavaScriptInlineFunction function) {
            return new EachJqueryFunction(function);
        }

        protected EachJqueryFunction(JavaScriptInlineFunction function) {
            super("each");
            this.addParameter(this.toParameterValue(function));
        }
    }

    public static final class ConfigurableFunction
    extends AbstractFunction {
        protected ConfigurableFunction(String functionName, AbstractConfig config) {
            super(functionName);
            if (!config.isEmpty()) {
                this.addParameter(config.toJsonString());
            }
        }
    }

    public static final class SimpleFunction
    extends AbstractFunction {
        protected SimpleFunction(String functionName) {
            super(functionName);
        }
    }

    public static class JavaScriptInlineFunction
    extends AbstractFunction {
        private final String functionBody;

        public JavaScriptInlineFunction(String functionBody) {
            super("function");
            this.functionBody = Strings2.nullToEmpty(functionBody);
        }

        @Override
        public String build() {
            return super.build() + "{" + this.functionBody + "}";
        }

        public boolean equals(Object o) {
            if (o instanceof JavaScriptInlineFunction) {
                return this.functionBody.equals(((JavaScriptInlineFunction)o).functionBody);
            }
            if (o instanceof String) {
                return this.functionBody.equals(o);
            }
            return false;
        }

        public int hashCode() {
            return this.functionBody.hashCode();
        }

        public String toString() {
            return this.functionBody;
        }

        public static String toString(JavaScriptInlineFunction value) {
            return value != null ? value.toString() : "null";
        }
    }
}

