/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.mapper;

import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.pis.BaseCmsPayment;
import de.adorsys.psd2.consent.api.pis.CmsAmount;
import de.adorsys.psd2.consent.api.pis.CmsBulkPayment;
import de.adorsys.psd2.consent.api.pis.CmsCommonPayment;
import de.adorsys.psd2.consent.api.pis.CmsCommonPaymentMapper;
import de.adorsys.psd2.consent.api.pis.CmsPayment;
import de.adorsys.psd2.consent.api.pis.CmsPeriodicPayment;
import de.adorsys.psd2.consent.api.pis.CmsRemittance;
import de.adorsys.psd2.consent.api.pis.CmsSinglePayment;
import de.adorsys.psd2.core.payment.model.AccountReference;
import de.adorsys.psd2.core.payment.model.Address;
import de.adorsys.psd2.core.payment.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.core.payment.model.ChargeBearer;
import de.adorsys.psd2.core.payment.model.DayOfExecution;
import de.adorsys.psd2.core.payment.model.ExecutionRule;
import de.adorsys.psd2.core.payment.model.FrequencyCode;
import de.adorsys.psd2.core.payment.model.PaymentInitiationJson;
import de.adorsys.psd2.core.payment.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.core.payment.model.RemittanceInformationStructured;
import de.adorsys.psd2.core.payment.model.Xs2aAmount;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CmsCommonPaymentMapperSupportImpl
implements CmsCommonPaymentMapper {
    private static final Logger log = LoggerFactory.getLogger(CmsCommonPaymentMapperSupportImpl.class);
    private final Xs2aObjectMapper xs2aObjectMapper;

    public CmsPayment mapToCmsSinglePayment(CmsCommonPayment cmsCommonPayment) {
        PaymentInitiationJson payment = this.convert(cmsCommonPayment.getPaymentData(), PaymentInitiationJson.class);
        if (payment == null) {
            return null;
        }
        return this.mapToCmsSinglePayment(payment, cmsCommonPayment);
    }

    public CmsPayment mapToCmsBulkPayment(CmsCommonPayment cmsCommonPayment) {
        BulkPaymentInitiationJson payment = this.convert(cmsCommonPayment.getPaymentData(), BulkPaymentInitiationJson.class);
        if (payment == null) {
            return null;
        }
        return this.mapToCmsBulkPayment(payment, cmsCommonPayment);
    }

    public CmsPayment mapToCmsPeriodicPayment(CmsCommonPayment cmsCommonPayment) {
        PeriodicPaymentInitiationJson payment = this.convert(cmsCommonPayment.getPaymentData(), PeriodicPaymentInitiationJson.class);
        if (payment == null) {
            return null;
        }
        return this.mapToCmsPeriodicPayment(payment, cmsCommonPayment);
    }

    private CmsPeriodicPayment mapToCmsPeriodicPayment(PeriodicPaymentInitiationJson periodicPaymentInitiationJson, CmsCommonPayment cmsCommonPayment) {
        CmsPeriodicPayment periodicPayment = new CmsPeriodicPayment(cmsCommonPayment.getPaymentProduct());
        this.fillBasePaymentFields((BaseCmsPayment)periodicPayment, cmsCommonPayment);
        periodicPayment.setPaymentStatus(cmsCommonPayment.getTransactionStatus());
        periodicPayment.setEndToEndIdentification(periodicPaymentInitiationJson.getEndToEndIdentification());
        periodicPayment.setInstructionIdentification(periodicPaymentInitiationJson.getInstructionIdentification());
        periodicPayment.setDebtorAccount(this.mapToAccountReference(periodicPaymentInitiationJson.getDebtorAccount()));
        Xs2aAmount instructedAmount = periodicPaymentInitiationJson.getInstructedAmount();
        periodicPayment.setInstructedAmount(new CmsAmount(this.mapToCurrency(instructedAmount.getCurrency()), BigDecimal.valueOf(Double.parseDouble(instructedAmount.getAmount()))));
        periodicPayment.setCreditorAccount(this.mapToAccountReference(periodicPaymentInitiationJson.getCreditorAccount()));
        periodicPayment.setCreditorAgent(periodicPaymentInitiationJson.getCreditorAgent());
        periodicPayment.setCreditorName(periodicPaymentInitiationJson.getCreditorName());
        periodicPayment.setCreditorAddress(this.mapToCmsAddress(periodicPaymentInitiationJson.getCreditorAddress()));
        periodicPayment.setRemittanceInformationUnstructured(periodicPaymentInitiationJson.getRemittanceInformationUnstructured());
        periodicPayment.setDayOfExecution(this.mapToPisDayOfExecution(periodicPaymentInitiationJson.getDayOfExecution()));
        periodicPayment.setStartDate(periodicPaymentInitiationJson.getStartDate());
        periodicPayment.setEndDate(periodicPaymentInitiationJson.getEndDate());
        periodicPayment.setExecutionRule((PisExecutionRule)this.mapToPisExecutionRule(periodicPaymentInitiationJson.getExecutionRule()).orElse(null));
        periodicPayment.setFrequency(this.mapToFrequencyCode(periodicPaymentInitiationJson.getFrequency()));
        periodicPayment.setUltimateDebtor(periodicPaymentInitiationJson.getUltimateDebtor());
        periodicPayment.setUltimateCreditor(periodicPaymentInitiationJson.getUltimateCreditor());
        periodicPayment.setPurposeCode(this.mapToPurposeCode(periodicPaymentInitiationJson.getPurposeCode()));
        periodicPayment.setRemittanceInformationStructured(this.mapToCmsRemittance(periodicPaymentInitiationJson.getRemittanceInformationStructured()));
        periodicPayment.setTppBrandLoggingInformation(cmsCommonPayment.getTppBrandLoggingInformation());
        periodicPayment.setRemittanceInformationStructuredArray(this.mapToCmsRemittanceList(periodicPaymentInitiationJson.getRemittanceInformationStructuredArray()));
        return periodicPayment;
    }

    private CmsBulkPayment mapToCmsBulkPayment(BulkPaymentInitiationJson bulkPaymentInitiationJson, CmsCommonPayment cmsCommonPayment) {
        CmsBulkPayment bulkPayment = new CmsBulkPayment();
        this.fillBasePaymentFields((BaseCmsPayment)bulkPayment, cmsCommonPayment);
        bulkPayment.setPaymentStatus(cmsCommonPayment.getTransactionStatus());
        bulkPayment.setBatchBookingPreferred(bulkPaymentInitiationJson.getBatchBookingPreferred().booleanValue());
        bulkPayment.setDebtorAccount(this.mapToAccountReference(bulkPaymentInitiationJson.getDebtorAccount()));
        bulkPayment.setBatchBookingPreferred(bulkPaymentInitiationJson.getBatchBookingPreferred().booleanValue());
        bulkPayment.setRequestedExecutionDate(bulkPaymentInitiationJson.getRequestedExecutionDate());
        List payments = bulkPaymentInitiationJson.getPayments().stream().map(p -> this.mapToCmsSinglePayment((PaymentInitiationJson)p, cmsCommonPayment)).collect(Collectors.toList());
        bulkPayment.setPayments(payments);
        bulkPayment.setTppBrandLoggingInformation(cmsCommonPayment.getTppBrandLoggingInformation());
        return bulkPayment;
    }

    private CmsSinglePayment mapToCmsSinglePayment(PaymentInitiationJson paymentInitiationJson, CmsCommonPayment cmsCommonPayment) {
        CmsSinglePayment singlePayment = new CmsSinglePayment(cmsCommonPayment.getPaymentProduct());
        this.fillBasePaymentFields((BaseCmsPayment)singlePayment, cmsCommonPayment);
        singlePayment.setEndToEndIdentification(paymentInitiationJson.getEndToEndIdentification());
        singlePayment.setInstructionIdentification(paymentInitiationJson.getInstructionIdentification());
        singlePayment.setDebtorAccount(this.mapToAccountReference(paymentInitiationJson.getDebtorAccount()));
        Xs2aAmount instructedAmount = paymentInitiationJson.getInstructedAmount();
        singlePayment.setInstructedAmount(new CmsAmount(this.mapToCurrency(instructedAmount.getCurrency()), BigDecimal.valueOf(Double.parseDouble(instructedAmount.getAmount()))));
        singlePayment.setCreditorAccount(this.mapToAccountReference(paymentInitiationJson.getCreditorAccount()));
        singlePayment.setCreditorAgent(paymentInitiationJson.getCreditorAgent());
        singlePayment.setCreditorName(paymentInitiationJson.getCreditorName());
        singlePayment.setCreditorAddress(this.mapToCmsAddress(paymentInitiationJson.getCreditorAddress()));
        singlePayment.setRemittanceInformationUnstructured(paymentInitiationJson.getRemittanceInformationUnstructured());
        singlePayment.setRequestedExecutionDate(paymentInitiationJson.getRequestedExecutionDate());
        singlePayment.setPaymentStatus(cmsCommonPayment.getTransactionStatus());
        singlePayment.setUltimateDebtor(paymentInitiationJson.getUltimateDebtor());
        singlePayment.setUltimateCreditor(paymentInitiationJson.getUltimateCreditor());
        singlePayment.setPurposeCode(this.mapToPurposeCode(paymentInitiationJson.getPurposeCode()));
        singlePayment.setRemittanceInformationStructured(this.mapToCmsRemittance(paymentInitiationJson.getRemittanceInformationStructured()));
        singlePayment.setTppBrandLoggingInformation(cmsCommonPayment.getTppBrandLoggingInformation());
        singlePayment.setRemittanceInformationStructuredArray(this.mapToCmsRemittanceList(paymentInitiationJson.getRemittanceInformationStructuredArray()));
        singlePayment.setChargeBearer((String)Optional.ofNullable(paymentInitiationJson.getChargeBearer()).map(ChargeBearer::toString).orElse(null));
        return singlePayment;
    }

    private <T> T convert(byte[] paymentData, Class<T> tClass) {
        try {
            return (T)(paymentData != null ? this.xs2aObjectMapper.readValue(paymentData, tClass) : null);
        }
        catch (IOException e) {
            log.warn("Can't convert byte[] to Object {}", (Object)e.getMessage());
            return null;
        }
    }

    private void fillBasePaymentFields(BaseCmsPayment payment, CmsCommonPayment cmsCommonPayment) {
        payment.setPaymentProduct(cmsCommonPayment.getPaymentProduct());
        payment.setPaymentId(cmsCommonPayment.getPaymentId());
        payment.setTppInfo(cmsCommonPayment.getTppInfo());
        payment.setPsuIdDatas(cmsCommonPayment.getPsuIdDatas());
        payment.setCreationTimestamp(cmsCommonPayment.getCreationTimestamp());
        payment.setStatusChangeTimestamp(cmsCommonPayment.getStatusChangeTimestamp());
    }

    private CmsRemittance mapToCmsRemittance(RemittanceInformationStructured remittanceInformationStructured) {
        if (remittanceInformationStructured == null) {
            return null;
        }
        CmsRemittance cmsRemittance = new CmsRemittance();
        cmsRemittance.setReference(remittanceInformationStructured.getReference());
        cmsRemittance.setReferenceType(remittanceInformationStructured.getReferenceType());
        cmsRemittance.setReferenceIssuer(remittanceInformationStructured.getReferenceIssuer());
        return cmsRemittance;
    }

    private List<CmsRemittance> mapToCmsRemittanceList(List<RemittanceInformationStructured> remittanceInformationStructuredArray) {
        if (CollectionUtils.isEmpty(remittanceInformationStructuredArray)) {
            return Collections.emptyList();
        }
        return remittanceInformationStructuredArray.stream().map(this::mapToCmsRemittance).collect(Collectors.toList());
    }

    private CmsAddress mapToCmsAddress(Address pisAddress) {
        return Optional.ofNullable(pisAddress).map(adr -> {
            CmsAddress cmsAddress = new CmsAddress();
            cmsAddress.setStreetName(adr.getStreetName());
            cmsAddress.setBuildingNumber(adr.getBuildingNumber());
            cmsAddress.setTownName(adr.getTownName());
            cmsAddress.setPostCode(adr.getPostCode());
            cmsAddress.setCountry(adr.getCountry());
            return cmsAddress;
        }).orElse(null);
    }

    private de.adorsys.psd2.xs2a.core.profile.AccountReference mapToAccountReference(AccountReference pisAccountReference) {
        return Optional.ofNullable(pisAccountReference).map(ref -> new de.adorsys.psd2.xs2a.core.profile.AccountReference(null, null, ref.getIban(), ref.getBban(), ref.getPan(), ref.getMaskedPan(), ref.getMsisdn(), this.mapToCurrency(ref.getCurrency()), null)).orElse(null);
    }

    private de.adorsys.psd2.xs2a.core.pis.FrequencyCode mapToFrequencyCode(FrequencyCode frequency) {
        return de.adorsys.psd2.xs2a.core.pis.FrequencyCode.valueOf((String)frequency.name());
    }

    private PisDayOfExecution mapToPisDayOfExecution(DayOfExecution dayOfExecution) {
        return Optional.ofNullable(dayOfExecution).map(DayOfExecution::toString).map(PisDayOfExecution::fromValue).orElse(null);
    }

    private Optional<PisExecutionRule> mapToPisExecutionRule(ExecutionRule executionRule) {
        return Optional.ofNullable(executionRule).map(ExecutionRule::toString).flatMap(PisExecutionRule::getByValue);
    }

    private String mapToPurposeCode(PurposeCode purposeCode) {
        return Optional.ofNullable(purposeCode).map(PurposeCode::toString).orElse(null);
    }

    private Currency mapToCurrency(String currency) {
        return Optional.ofNullable(currency).map(Currency::getInstance).orElse(null);
    }

    @ConstructorProperties(value={"xs2aObjectMapper"})
    public CmsCommonPaymentMapperSupportImpl(Xs2aObjectMapper xs2aObjectMapper) {
        this.xs2aObjectMapper = xs2aObjectMapper;
    }
}

